/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.tracking.entity;

import java.util.ArrayList;
import java.util.List;
import net.caffeinemc.mods.lithium.common.tracking.entity.SectionedEntityMovementTracker;
import net.caffeinemc.mods.lithium.common.util.tuples.WorldSectionBox;
import net.caffeinemc.mods.lithium.common.world.LithiumData;
import net.caffeinemc.mods.lithium.mixin.block.hopper.EntitySectionAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SectionedInventoryEntityMovementTracker<S>
extends SectionedEntityMovementTracker<Entity> {
    public SectionedInventoryEntityMovementTracker(WorldSectionBox entityAccessBox, Class<S> clazz) {
        super(entityAccessBox, clazz);
    }

    public static <S> SectionedInventoryEntityMovementTracker<S> registerAt(ServerLevel world, AABB interactionArea, Class<S> clazz) {
        WorldSectionBox worldSectionBox = WorldSectionBox.entityAccessBox((Level)world, interactionArea);
        SectionedInventoryEntityMovementTracker<S> tracker = new SectionedInventoryEntityMovementTracker<S>(worldSectionBox, clazz);
        tracker = ((LithiumData)world).lithium$getData().entityMovementTrackers().getCanonical(tracker);
        tracker.register(world);
        return tracker;
    }

    public List<S> getEntities(AABB box) {
        ArrayList entities = new ArrayList();
        for (int i = 0; i < this.sortedSections.size(); ++i) {
            if (!this.sectionVisible[i]) continue;
            ClassInstanceMultiMap collection = ((EntitySectionAccessor)this.sortedSections.get(i)).getCollection();
            for (Object entity : collection.find((Class)this.clazz)) {
                Entity inventoryEntity = (Entity)entity;
                if (!inventoryEntity.isAlive() || !inventoryEntity.getBoundingBox().intersects(box)) continue;
                entities.add(entity);
            }
        }
        return entities;
    }
}

