/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.world.interests.iterator;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.util.Distances;
import net.caffeinemc.mods.lithium.common.util.tuples.SortedPointOfInterest;
import net.caffeinemc.mods.lithium.common.world.interests.PointOfInterestSetExtended;
import net.caffeinemc.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class NearbyPointOfInterestStream
extends Spliterators.AbstractSpliterator<PoiRecord>
implements Consumer<PoiRecord> {
    public static final Comparator<SortedPointOfInterest> NEGATIVE_Y_POINT_COMPARATOR = (o1, o2) -> {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int cmp = Integer.compare(o1.distanceSq(), o2.distanceSq());
        if (cmp != 0) {
            return cmp;
        }
        int negativeY = Integer.compare(o1.getY(), o2.getY());
        if (negativeY != 0) {
            return negativeY;
        }
        int cmp3 = Integer.compare(SectionPos.blockToSectionCoord((int)o1.getZ()), SectionPos.blockToSectionCoord((int)o2.getZ()));
        if (cmp3 != 0) {
            return cmp3;
        }
        return Integer.compare(SectionPos.blockToSectionCoord((int)o1.getX()), SectionPos.blockToSectionCoord((int)o2.getX()));
    };
    public static final Comparator<SortedPointOfInterest> POINT_COMPARATOR = (o1, o2) -> {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int cmp = Integer.compare(o1.distanceSq(), o2.distanceSq());
        if (cmp != 0) {
            return cmp;
        }
        int cmp2 = Integer.compare(SectionPos.blockToSectionCoord((int)o1.getZ()), SectionPos.blockToSectionCoord((int)o2.getZ()));
        if (cmp2 != 0) {
            return cmp2;
        }
        int cmp3 = Integer.compare(SectionPos.blockToSectionCoord((int)o1.getX()), SectionPos.blockToSectionCoord((int)o2.getX()));
        if (cmp3 != 0) {
            return cmp3;
        }
        return Integer.compare(SectionPos.blockToSectionCoord((int)o1.getY()), SectionPos.blockToSectionCoord((int)o2.getY()));
    };
    private final RegionBasedStorageSectionExtended<PoiSection> storage;
    private final Predicate<Holder<PoiType>> typeSelector;
    private final PoiManager.Occupancy occupationStatus;
    private final BlockPos origin;
    private final Predicate<PoiRecord> afterSortingPredicate;
    private final Comparator<SortedPointOfInterest> pointComparatorWithoutInSectionOrder;
    private final int chunkYMin;
    private final int clampedOriginChunkY;
    private final BiPredicate<BlockPos, BlockPos> distanceLimit;
    private final double minChunkYDistSq;
    private final ObjectArrayList<QueuedSection> queuedPOISections;
    private int queuedSectionsSearched;
    private boolean forciblyDeplete;
    private final int forciblyDepleteTrigger;
    private int ring;
    private final int ringMax;
    private final LongIterator ringIterator;
    private final int ringClosestEdgeDistance;
    private double closestRingDistanceSq;
    private int nextSectionDistanceSq;
    private int minCollectedElementDistanceSq = Integer.MAX_VALUE;
    private int minCollectedElementIndex = -1;
    private final ArrayList<SortedPointOfInterest> points;
    private int nextPointIndex;
    private int sortedToIndex;

    public NearbyPointOfInterestStream(Predicate<Holder<PoiType>> typeSelector, PoiManager.Occupancy status, @Nullable Predicate<PoiRecord> afterSortingPredicate, BlockPos origin, int radius, RegionBasedStorageSectionExtended<PoiSection> storage, BiPredicate<BlockPos, BlockPos> distanceLimit, Comparator<SortedPointOfInterest> sortOrder) {
        super(Long.MAX_VALUE, 16);
        this.storage = storage;
        this.points = new ArrayList();
        this.occupationStatus = status;
        this.typeSelector = typeSelector;
        this.origin = origin;
        this.chunkYMin = this.storage.lithium$getChunkYMin();
        int chunkYMax = this.storage.lithium$getChunkYMaxInclusive();
        this.clampedOriginChunkY = Math.clamp((long)SectionPos.blockToSectionCoord((int)origin.getY()), this.chunkYMin, chunkYMax);
        int minChunkYDist = Math.min(Math.max(this.origin.getY(), SectionPos.sectionToBlockCoord((int)this.chunkYMin)), SectionPos.sectionToBlockCoord((int)chunkYMax, (int)15)) - this.origin.getY();
        this.minChunkYDistSq = minChunkYDist * minChunkYDist;
        int originX = this.origin.getX();
        int originZ = this.origin.getZ();
        int chunkMaxX = SectionPos.blockToSectionCoord((int)(origin.getX() + radius));
        int chunkMinX = SectionPos.blockToSectionCoord((int)(origin.getX() - radius));
        int chunkMaxZ = SectionPos.blockToSectionCoord((int)(origin.getZ() + radius));
        int chunkMinZ = SectionPos.blockToSectionCoord((int)(origin.getZ() - radius));
        this.ring = 0;
        int originChunkX = SectionPos.blockToSectionCoord((int)originX);
        int originChunkZ = SectionPos.blockToSectionCoord((int)originZ);
        this.ringMax = Math.max(Math.max(chunkMaxX - originChunkX, originChunkX - chunkMinX), Math.max(chunkMaxZ - originChunkZ, originChunkZ - chunkMinZ));
        this.ringIterator = this.getRingsOfChunksIterator(originChunkX, chunkMaxX, chunkMinX, originChunkZ, chunkMaxZ, chunkMinZ);
        this.ringClosestEdgeDistance = Math.min(Math.min((originX & 0xF) + 1, 16 - originX & 0xF), Math.min((originZ & 0xF) + 1, 16 - originZ & 0xF));
        this.closestRingDistanceSq = this.getPotentialRingDistanceSq();
        this.nextSectionDistanceSq = Integer.MAX_VALUE;
        this.minCollectedElementDistanceSq = Integer.MAX_VALUE;
        int sectionsPerChunk = chunkYMax - this.chunkYMin + 1;
        int listSize = sectionsPerChunk * 9;
        this.queuedPOISections = new ObjectArrayList(listSize);
        this.queuedSectionsSearched = 0;
        this.forciblyDeplete = false;
        this.forciblyDepleteTrigger = listSize - sectionsPerChunk;
        this.distanceLimit = distanceLimit;
        this.afterSortingPredicate = afterSortingPredicate;
        this.pointComparatorWithoutInSectionOrder = sortOrder;
    }

    @Override
    public void accept(PoiRecord poiRecord) {
        if (this.distanceLimit.test(this.origin, poiRecord.getPos())) {
            this.collectPoint(poiRecord);
        }
    }

    private void collectPoint(PoiRecord point) {
        SortedPointOfInterest poi = new SortedPointOfInterest(point, this.origin);
        this.points.add(poi);
        if (poi.distanceSq() <= this.minCollectedElementDistanceSq) {
            this.updateMinPoint(poi, this.points.size() - 1);
        }
    }

    private void updateMinPoint(SortedPointOfInterest poi, int index) {
        int poiDist = poi.distanceSq();
        if (this.minCollectedElementIndex >= 0 && poiDist == this.minCollectedElementDistanceSq) {
            if (this.pointComparatorWithoutInSectionOrder.compare(this.points.get(this.minCollectedElementIndex), poi) > 0) {
                this.minCollectedElementIndex = index;
            }
        } else if (this.minCollectedElementIndex != -2) {
            this.minCollectedElementIndex = index;
            this.minCollectedElementDistanceSq = poiDist;
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super PoiRecord> action) {
        if (this.nextPointIndex < this.points.size() && this.tryAdvancePoint(action)) {
            return true;
        }
        while (this.ringIterator.hasNext() || !this.isSectionListEmpty()) {
            this.keepAddingRingsUntilSufficient();
            int previousSize = this.points.size();
            while (!this.isSectionListEmpty() && (double)this.minCollectedElementDistanceSq >= this.getMinimumNextPotentialDistanceSq()) {
                long sectionPos = ((QueuedSection)this.queuedPOISections.get((int)this.queuedSectionsSearched++)).sectionPos;
                this.nextSectionDistanceSq = this.getNextSectionDistanceSq();
                Optional<PoiSection> poiSection = this.storage.lithium$getElementAt(sectionPos);
                if (poiSection.isPresent()) {
                    ((PointOfInterestSetExtended)poiSection.get()).lithium$collectMatchingPoints(this.typeSelector, this.occupationStatus, this);
                }
                if (this.forciblyDeplete) {
                    boolean bl = this.forciblyDeplete = !this.isSectionListEmpty();
                }
                if (this.points.size() <= previousSize && (this.forciblyDeplete || !((double)this.nextSectionDistanceSq > this.closestRingDistanceSq))) continue;
                break;
            }
            if (!this.tryAdvancePoint(action)) continue;
            return true;
        }
        return this.tryAdvancePoint(action);
    }

    private boolean tryAdvancePoint(Consumer<? super PoiRecord> action) {
        while (this.nextPointIndex < this.points.size()) {
            SortedPointOfInterest next;
            if (this.minCollectedElementIndex >= 0) {
                next = this.points.get(this.minCollectedElementIndex);
                if ((double)next.distanceSq() >= this.getMinimumNextPotentialDistanceSq()) {
                    return false;
                }
                this.points.set(this.minCollectedElementIndex, null);
                this.minCollectedElementIndex = -2;
                this.minCollectedElementDistanceSq = Integer.MAX_VALUE;
            } else {
                if (this.sortedToIndex <= this.nextPointIndex) {
                    this.points.subList(this.sortedToIndex, this.points.size()).sort(this.pointComparatorWithoutInSectionOrder);
                    this.sortedToIndex = this.points.size();
                }
                if ((next = this.points.get(this.nextPointIndex)) != null && (double)next.distanceSq() >= this.getMinimumNextPotentialDistanceSq()) {
                    this.minCollectedElementDistanceSq = next.distanceSq();
                    this.minCollectedElementIndex = this.nextPointIndex;
                    return false;
                }
                ++this.nextPointIndex;
            }
            if (next == null || this.afterSortingPredicate != null && !this.afterSortingPredicate.test(next.poi())) continue;
            action.accept((PoiRecord)next.poi());
            return true;
        }
        return false;
    }

    private void keepAddingRingsUntilSufficient() {
        if (!this.forciblyDeplete && this.ringIterator.hasNext() && (double)Math.min(this.minCollectedElementDistanceSq, this.nextSectionDistanceSq) >= this.closestRingDistanceSq) {
            this.queuedPOISections.removeElements(0, this.queuedSectionsSearched);
            this.queuedSectionsSearched = 0;
            int ringStart = this.ring;
            do {
                int currentChunkZ;
                long chunkPos;
                int currentChunkX;
                BlockPos closestPosInChunk;
                if (this.distanceLimit.test(this.origin, closestPosInChunk = Distances.getClosestPosInChunk(this.origin, currentChunkX = ChunkPos.getX((long)(chunkPos = this.ringIterator.nextLong())), currentChunkZ = ChunkPos.getZ((long)chunkPos)))) {
                    BitSet poiSections = this.storage.lithium$getNonEmptyPOISections(currentChunkX, currentChunkZ);
                    int nextUpwardSectionIndex = poiSections.nextSetBit(this.clampedOriginChunkY - this.chunkYMin);
                    int nextUpwardSectionDistance = this.getYDistanceFromBitIndex(nextUpwardSectionIndex);
                    int nextDownwardSectionIndex = poiSections.previousSetBit(this.clampedOriginChunkY - this.chunkYMin - 1);
                    int nextDownwardSectionDistance = this.getYDistanceFromBitIndex(nextDownwardSectionIndex);
                    while (nextUpwardSectionIndex != -1 || nextDownwardSectionIndex != -1) {
                        int currentSectionY;
                        if (nextDownwardSectionDistance <= nextUpwardSectionDistance && nextDownwardSectionIndex != -1) {
                            currentSectionY = nextDownwardSectionIndex + this.chunkYMin;
                            nextDownwardSectionIndex = poiSections.previousSetBit(nextDownwardSectionIndex - 1);
                            nextDownwardSectionDistance = this.getYDistanceFromBitIndex(nextDownwardSectionIndex);
                            if (!this.distanceLimit.test(this.origin, closestPosInChunk.atY(Distances.getClosestBlockCoordInSection(this.origin.getY(), currentSectionY)))) {
                                nextDownwardSectionIndex = -1;
                                continue;
                            }
                        } else {
                            currentSectionY = nextUpwardSectionIndex + this.chunkYMin;
                            nextUpwardSectionIndex = poiSections.nextSetBit(nextUpwardSectionIndex + 1);
                            nextUpwardSectionDistance = this.getYDistanceFromBitIndex(nextUpwardSectionIndex);
                            if (!this.distanceLimit.test(this.origin, closestPosInChunk.atY(Distances.getClosestBlockCoordInSection(this.origin.getY(), currentSectionY)))) {
                                nextUpwardSectionIndex = -1;
                                continue;
                            }
                        }
                        this.queuedPOISections.add((Object)new QueuedSection(SectionPos.asLong((int)currentChunkX, (int)currentSectionY, (int)currentChunkZ), Math.toIntExact(Distances.getMinSectionDistanceSq(this.origin, currentChunkX, currentSectionY, currentChunkZ))));
                    }
                    boolean bl = this.forciblyDeplete = this.queuedPOISections.size() > this.forciblyDepleteTrigger;
                }
                if (!this.forciblyDeplete && this.ring <= ringStart) continue;
                this.sortSectionList();
                this.nextSectionDistanceSq = this.getNextSectionDistanceSq();
                if (this.forciblyDeplete || (double)Math.min(this.minCollectedElementDistanceSq, this.nextSectionDistanceSq) < this.closestRingDistanceSq) break;
                ringStart = this.ring;
            } while (this.ringIterator.hasNext());
        }
    }

    private void sortSectionList() {
        this.queuedPOISections.subList(this.queuedSectionsSearched, this.queuedPOISections.size()).sort(Comparator.comparingInt(qS -> qS.minDistance));
    }

    private boolean isSectionListEmpty() {
        return this.queuedPOISections.size() <= this.queuedSectionsSearched;
    }

    private double getMinimumNextPotentialDistanceSq() {
        return Math.min((double)this.nextSectionDistanceSq, this.closestRingDistanceSq);
    }

    private int getNextSectionDistanceSq() {
        return this.isSectionListEmpty() ? Integer.MAX_VALUE : ((QueuedSection)this.queuedPOISections.get(this.queuedSectionsSearched)).minDistance();
    }

    private int getYDistanceFromBitIndex(int bitIndex) {
        return bitIndex == -1 ? Integer.MAX_VALUE : Math.abs(Distances.getClosestBlockCoordInSection(this.origin.getY(), bitIndex + this.chunkYMin) - this.origin.getY());
    }

    private double getPotentialRingDistanceSq() {
        int ringDistance = Math.max(this.ring - 1, 0) * 16 + (this.ring > 0 ? this.ringClosestEdgeDistance : 0);
        return this.ring > this.ringMax ? Double.MAX_VALUE : (double)(ringDistance * ringDistance) + this.minChunkYDistSq;
    }

    private LongIterator getRingsOfChunksIterator(final int cx, final int maxX, final int minX, final int cz, final int maxZ, final int minZ) {
        return new LongIterator(){
            int x = 0;
            int fx = cx;
            int z = 0;
            int fz = cz;

            public long nextLong() {
                long res = ChunkPos.asLong((int)this.fx, (int)this.fz);
                do {
                    int n = this.z = this.z > 0 ? -this.z : 1 - this.z;
                    if (this.z > NearbyPointOfInterestStream.this.ring) {
                        int n2 = this.x = this.x > 0 ? -this.x : 1 - this.x;
                        if (this.x > NearbyPointOfInterestStream.this.ring) {
                            this.x = 0;
                            ++NearbyPointOfInterestStream.this.ring;
                            NearbyPointOfInterestStream.this.closestRingDistanceSq = NearbyPointOfInterestStream.this.getPotentialRingDistanceSq();
                        }
                        this.z = this.x < NearbyPointOfInterestStream.this.ring && this.x > -NearbyPointOfInterestStream.this.ring ? NearbyPointOfInterestStream.this.ring : 0;
                    }
                    this.fx = cx + this.x;
                    this.fz = cz + this.z;
                } while (NearbyPointOfInterestStream.this.ring <= NearbyPointOfInterestStream.this.ringMax && this.fx < minX || this.fx > maxX || this.fz < minZ || this.fz > maxZ);
                return res;
            }

            public boolean hasNext() {
                return NearbyPointOfInterestStream.this.ring <= NearbyPointOfInterestStream.this.ringMax;
            }
        };
    }

    public PoiRecord getFirst() {
        PoiRecord[] poiRecords = new PoiRecord[1];
        this.tryAdvance((Consumer<? super PoiRecord>)((Consumer<PoiRecord>)poiRecord -> {
            poiRecords[0] = poiRecord;
        }));
        return poiRecords[0];
    }

    private record QueuedSection(long sectionPos, int minDistance) {
    }
}

