/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.raid;

import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.raid.Raid;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Raid.class})
public abstract class RaidMixin {
    @Shadow
    @Final
    private ServerBossEvent raidEvent;
    @Shadow
    private float totalHealth;
    @Unique
    private boolean isBarDirty;

    @Shadow
    public abstract float getHealthOfLivingRaiders();

    @Inject(method={"tick(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.isBarDirty) {
            this.raidEvent.setProgress(Mth.clamp((float)(this.getHealthOfLivingRaiders() / this.totalHealth), (float)0.0f, (float)1.0f));
            this.isBarDirty = false;
        }
    }

    @Overwrite
    public void updateBossbar() {
        this.isBarDirty = true;
    }
}

