/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BIngredients;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.IngedientAddEvent;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.depend.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BukkitConstants;
import com.dre.brewery.utility.MaterialUtil;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BCauldron {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final Config config = ConfigManager.getConfig(Config.class);
    private static final Lang lang = ConfigManager.getConfig(Lang.class);
    public static final int PARTICLEPAUSE = 15;
    public static Random particleRandom = new Random();
    private static final Set<UUID> plInteracted = new HashSet<UUID>();
    public static Map<Block, BCauldron> bcauldrons = new ConcurrentHashMap<Block, BCauldron>();
    private BIngredients ingredients = new BIngredients();
    private final Block block;
    private int state = 0;
    private boolean changed = false;
    private BCauldronRecipe particleRecipe;
    private Color particleColor;
    private final Location particleLocation;
    private final UUID id;

    public BCauldron(Block block) {
        this.block = block;
        this.particleLocation = block.getLocation().add(0.5, 0.9, 0.5);
        this.id = UUID.randomUUID();
    }

    public BCauldron(Block block, BIngredients ingredients, int state, UUID id) {
        this.block = block;
        this.state = state;
        this.ingredients = ingredients;
        this.particleLocation = block.getLocation().add(0.5, 0.9, 0.5);
        this.id = id;
    }

    public boolean onUpdate() {
        if (!BUtil.isChunkLoaded(this.block)) {
            this.increaseState();
        } else {
            if (!MaterialUtil.isWaterCauldron(this.block.getType())) {
                return false;
            }
            if (MaterialUtil.isCauldronHeatSource(this.block.getRelative(BlockFace.DOWN))) {
                this.increaseState();
            }
        }
        return true;
    }

    public void increaseState() {
        ++this.state;
        if (this.changed) {
            this.ingredients = this.ingredients.copy();
            this.changed = false;
        }
        this.particleColor = null;
    }

    public void add(ItemStack ingredient, RecipeItem rItem) {
        if (ingredient == null || ingredient.getType() == Material.AIR) {
            return;
        }
        if (this.changed) {
            this.ingredients = this.ingredients.copy();
            this.changed = false;
        }
        this.particleRecipe = null;
        this.particleColor = null;
        this.ingredients.add(ingredient, rItem);
        this.block.getWorld().playEffect(this.block.getLocation(), Effect.EXTINGUISH, 0);
        if (this.state > 0) {
            --this.state;
        }
        if (config.isEnableCauldronParticles() && !config.isMinimalParticles()) {
            this.block.getWorld().spawnParticle(BukkitConstants.INSTANT_EFFECT, this.particleLocation, 2, 0.2, 0.0, 0.2, new BukkitConstants.ParticleSpellWrapper().toInstance(Color.WHITE, 1.0f));
            this.block.getWorld().spawnParticle(BukkitConstants.SPLASH, this.particleLocation, 10, 0.2, 0.0, 0.2);
        }
    }

    @Nullable
    public static BCauldron get(Block block) {
        return bcauldrons.get(block);
    }

    public static boolean ingredientAdd(Block block, ItemStack ingredient, Player player) {
        if (MaterialUtil.getFillLevel(block) != 0) {
            if (!BCauldronRecipe.acceptedMaterials.contains(ingredient.getType()) && !ingredient.hasItemMeta()) {
                return false;
            }
            RecipeItem rItem = RecipeItem.getMatchingRecipeItem(ingredient, false);
            if (rItem == null) {
                return false;
            }
            BCauldron bcauldron = BCauldron.get(block);
            if (bcauldron == null) {
                bcauldron = new BCauldron(block);
                bcauldrons.put(block, bcauldron);
            }
            IngedientAddEvent event = new IngedientAddEvent(player, block, bcauldron, ingredient.clone(), rItem);
            BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                bcauldron.add(event.getIngredient(), event.getRecipeItem());
                return event.willTakeItem();
            }
            return false;
        }
        return false;
    }

    public boolean fill(Player player, Block block) {
        if (!player.hasPermission("brewery.cauldron.fill")) {
            lang.sendEntry((CommandSender)player, "Perms_NoCauldronFill", new Object[0]);
            return true;
        }
        ItemStack potion = this.ingredients.cook(this.state, player);
        if (potion == null) {
            return false;
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
            BlockData data = block.getBlockData();
            if (!(data instanceof Levelled)) {
                bcauldrons.remove(block);
                return false;
            }
            Levelled cauldron = (Levelled)data;
            if (cauldron.getLevel() <= 0) {
                bcauldrons.remove(block);
                return false;
            }
            if (MaterialUtil.WATER_CAULDRON != null && cauldron.getLevel() == 1) {
                block.setType(Material.CAULDRON);
                bcauldrons.remove(block);
            } else {
                cauldron.setLevel(cauldron.getLevel() - 1);
                block.setBlockData(data);
                if (cauldron.getLevel() <= 0) {
                    bcauldrons.remove(block);
                } else {
                    this.changed = true;
                }
            }
        } else {
            byte data = block.getData();
            if (data > 3) {
                data = 3;
            } else if (data <= 0) {
                bcauldrons.remove(block);
                return false;
            }
            data = (byte)(data - 1);
            MaterialUtil.setData(block, data);
            if (data == 0) {
                bcauldrons.remove(block);
            } else {
                this.changed = true;
            }
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_9)) {
            block.getWorld().playSound(block.getLocation(), Sound.ITEM_BOTTLE_FILL, 1.0f, 1.0f);
        }
        BCauldron.giveItem(player, potion);
        return true;
    }

    public static void printTime(Player player, Block block) {
        if (!player.hasPermission("brewery.cauldron.time")) {
            lang.sendEntry((CommandSender)player, "Error_NoPermissions", new Object[0]);
            return;
        }
        BCauldron bcauldron = BCauldron.get(block);
        if (bcauldron != null) {
            if (bcauldron.state > 1) {
                lang.sendEntry((CommandSender)player, "Player_CauldronInfo1", "" + bcauldron.state);
            } else {
                lang.sendEntry((CommandSender)player, "Player_CauldronInfo2", new Object[0]);
            }
        }
    }

    public void cookEffect() {
        if (BUtil.isChunkLoaded(this.block) && MaterialUtil.isCauldronHeatSource(this.block.getRelative(BlockFace.DOWN))) {
            Color color = this.getParticleColor();
            if (VERSION.isOrLater(MinecraftVersion.V1_21)) {
                this.block.getWorld().spawnParticle(BukkitConstants.ENTITY_EFFECT, this.getRandParticleLoc(), 0, (Object)color);
            } else {
                this.block.getWorld().spawnParticle(BukkitConstants.ENTITY_EFFECT, this.getRandParticleLoc(), 0, (double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0, 1025.0);
            }
            if (config.isMinimalParticles()) {
                return;
            }
            if ((double)particleRandom.nextFloat() > 0.85) {
                this.block.getWorld().spawnParticle(BukkitConstants.LARGE_SMOKE, this.getRandParticleLoc(), 0, 0.0, 1.0, 0.0, 0.09);
            }
            if ((double)particleRandom.nextFloat() > 0.2) {
                this.block.getWorld().spawnParticle(BukkitConstants.SPLASH, this.particleLocation, 1, 0.2, 0.0, 0.2);
            }
            if (VERSION.isOrLater(MinecraftVersion.V1_13) && (double)particleRandom.nextFloat() > 0.4) {
                this.block.getWorld().spawnParticle(BukkitConstants.DUST, this.particleLocation, 2, 0.15, 0.2, 0.15, (Object)new Particle.DustOptions(color, 1.5f));
            }
        }
    }

    private Location getRandParticleLoc() {
        return new Location(this.particleLocation.getWorld(), this.particleLocation.getX() + particleRandom.nextDouble() * 0.8 - 0.4, this.particleLocation.getY(), this.particleLocation.getZ() + particleRandom.nextDouble() * 0.8 - 0.4);
    }

    @NotNull
    public Color getParticleColor() {
        int index;
        if (this.state < 1) {
            return Color.fromRGB((int)153, (int)221, (int)255);
        }
        if (this.particleColor != null) {
            return this.particleColor;
        }
        if (this.particleRecipe == null) {
            this.particleRecipe = this.ingredients.getCauldronRecipe();
        }
        List<Tuple<Integer, Color>> colorList = null;
        if (this.particleRecipe != null) {
            colorList = this.particleRecipe.getParticleColor();
        }
        if (colorList == null || colorList.isEmpty()) {
            colorList = new ArrayList<Tuple<Integer, Color>>(1);
            colorList.add(new Tuple<Integer, Color>(10, Color.fromRGB((int)77, (int)166, (int)255)));
        }
        for (index = 0; index < colorList.size() - 1 && colorList.get(index).a() < this.state; ++index) {
        }
        int minute = colorList.get(index).a();
        if (minute > this.state) {
            Color prevColor;
            int prevPos;
            if (index > 0) {
                prevPos = colorList.get(index - 1).a();
                prevColor = colorList.get(index - 1).b();
            } else {
                prevPos = 0;
                prevColor = Color.fromRGB((int)153, (int)221, (int)255);
            }
            this.particleColor = BUtil.weightedMixColor(prevColor, prevPos, this.state, colorList.get(index).b(), minute);
        } else if (minute == this.state) {
            this.particleColor = colorList.get(index).b();
        } else if (index > 0) {
            this.particleColor = colorList.get(index).b();
        } else {
            Color nextColor = Color.fromRGB((int)138, (int)153, (int)168);
            int nextPos = (int)((float)minute * 2.6f);
            this.particleColor = nextPos <= this.state ? nextColor : BUtil.weightedMixColor(colorList.get(index).b(), minute, this.state, nextColor, nextPos);
        }
        return this.particleColor;
    }

    public static void processCookEffects() {
        if (!config.isEnableCauldronParticles()) {
            return;
        }
        if (bcauldrons.isEmpty()) {
            return;
        }
        float chance = 0.06666667f;
        for (BCauldron cauldron : bcauldrons.values()) {
            if (!(particleRandom.nextFloat() < 0.06666667f)) continue;
            BreweryPlugin.getScheduler().runTask(cauldron.block.getLocation(), cauldron::cookEffect);
        }
    }

    public static void clickCauldron(PlayerInteractEvent event) {
        Material materialInHand = event.getMaterial();
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        assert (clickedBlock != null);
        if (materialInHand == Material.AIR || materialInHand == Material.BUCKET) {
            return;
        }
        if (materialInHand == MaterialUtil.CLOCK) {
            BCauldron.printTime(player, clickedBlock);
            return;
        }
        if (materialInHand == Material.GLASS_BOTTLE) {
            assert (item != null);
            if (player.getInventory().firstEmpty() != -1 || item.getAmount() == 1) {
                BCauldron bcauldron = BCauldron.get(clickedBlock);
                if (bcauldron != null && bcauldron.fill(player, clickedBlock)) {
                    event.setCancelled(true);
                    if (player.hasPermission("brewery.cauldron.fill")) {
                        if (item.getAmount() > 1) {
                            item.setAmount(item.getAmount() - 1);
                        } else {
                            BUtil.setItemInHand(event, Material.AIR, false);
                        }
                    }
                }
            } else {
                event.setCancelled(true);
            }
            return;
        }
        if (materialInHand == Material.WATER_BUCKET) {
            if (VERSION.isOrEarlier(MinecraftVersion.V1_9) && MaterialUtil.getFillLevel(clickedBlock) == 1) {
                BCauldron.remove(clickedBlock);
            }
            return;
        }
        Block down = clickedBlock.getRelative(BlockFace.DOWN);
        if (MaterialUtil.isCauldronHeatSource(down)) {
            event.setCancelled(true);
            boolean handSwap = false;
            if (VERSION.isOrLater(MinecraftVersion.V1_9)) {
                if (event.getHand() == EquipmentSlot.HAND) {
                    UUID id = player.getUniqueId();
                    plInteracted.add(id);
                    BreweryPlugin.getScheduler().runTask(() -> plInteracted.remove(id));
                } else if (event.getHand() == EquipmentSlot.OFF_HAND && !plInteracted.remove(player.getUniqueId())) {
                    item = player.getInventory().getItemInMainHand();
                    if (item.getType() != Material.AIR) {
                        materialInHand = item.getType();
                        handSwap = true;
                    } else {
                        ItemStack itemStack = item = config.isUseOffhandForCauldron() ? event.getItem() : null;
                    }
                }
            }
            if (item == null) {
                return;
            }
            if (!player.hasPermission("brewery.cauldron.insert")) {
                lang.sendEntry((CommandSender)player, "Perms_NoCauldronInsert", new Object[0]);
                return;
            }
            if (BCauldron.ingredientAdd(clickedBlock, item, player)) {
                boolean isBucket = item.getType().name().endsWith("_BUCKET");
                boolean isBottle = MaterialUtil.isBottle(item.getType());
                if (item.getAmount() > 1) {
                    item.setAmount(item.getAmount() - 1);
                    if (isBucket) {
                        BCauldron.giveItem(player, new ItemStack(Material.BUCKET));
                    } else if (isBottle) {
                        BCauldron.giveItem(player, new ItemStack(Material.GLASS_BOTTLE));
                    }
                } else if (isBucket) {
                    BUtil.setItemInHand(event, Material.BUCKET, handSwap);
                } else if (isBottle) {
                    BUtil.setItemInHand(event, Material.GLASS_BOTTLE, handSwap);
                } else {
                    item.setAmount(0);
                }
            }
        }
    }

    public static void reload() {
        if (!config.isEnableCauldronParticles()) {
            return;
        }
        TaskScheduler scheduler = BreweryPlugin.getScheduler();
        for (BCauldron cauldron : bcauldrons.values()) {
            cauldron.particleRecipe = null;
            cauldron.particleColor = null;
            scheduler.execute(cauldron.block.getLocation(), () -> {
                if (BUtil.isChunkLoaded(cauldron.block) && MaterialUtil.isCauldronHeatSource(cauldron.block.getRelative(BlockFace.DOWN))) {
                    cauldron.getParticleColor();
                }
            });
        }
    }

    public static boolean remove(Block block) {
        return bcauldrons.remove(block) != null;
    }

    public static boolean hasDataInWorld(World world) {
        return bcauldrons.keySet().stream().anyMatch(block -> block.getWorld().equals((Object)world));
    }

    public static void onUnload(World world) {
        bcauldrons.keySet().removeIf(block -> block.getWorld().equals((Object)world));
    }

    public static void unloadWorlds() {
        List worlds = BreweryPlugin.getInstance().getServer().getWorlds();
        bcauldrons.keySet().removeIf(block -> !worlds.contains(block.getWorld()));
    }

    public static void save(ConfigurationSection config, ConfigurationSection oldData) {
        BUtil.createWorldSections(config);
        if (!bcauldrons.isEmpty()) {
            int id = 0;
            for (BCauldron cauldron : bcauldrons.values()) {
                String worldName = cauldron.block.getWorld().getName();
                String prefix = worldName.startsWith("DXL_") ? BUtil.getDxlName(worldName) + "." + id : cauldron.block.getWorld().getUID().toString() + "." + id;
                config.set(prefix + ".block", (Object)(cauldron.block.getX() + "/" + cauldron.block.getY() + "/" + cauldron.block.getZ()));
                if (cauldron.state != 0) {
                    config.set(prefix + ".state", (Object)cauldron.state);
                }
                config.set(prefix + ".ingredients", (Object)cauldron.ingredients.serializeIngredients());
                ++id;
            }
        }
        if (oldData != null) {
            for (String uuid : oldData.getKeys(false)) {
                if (config.contains(uuid)) continue;
                config.set(uuid, oldData.get(uuid));
            }
        }
    }

    public static void giveItem(Player player, ItemStack item) {
        BreweryPlugin.getScheduler().runTaskLater(() -> player.getInventory().addItem(new ItemStack[]{item}), 1L);
    }

    public BIngredients getIngredients() {
        return this.ingredients;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getState() {
        return this.state;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public BCauldronRecipe getParticleRecipe() {
        return this.particleRecipe;
    }

    public Location getParticleLocation() {
        return this.particleLocation;
    }

    public UUID getId() {
        return this.id;
    }

    public void setIngredients(BIngredients ingredients) {
        this.ingredients = ingredients;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void setParticleRecipe(BCauldronRecipe particleRecipe) {
        this.particleRecipe = particleRecipe;
    }

    public void setParticleColor(Color particleColor) {
        this.particleColor = particleColor;
    }

    public static Map<Block, BCauldron> getBcauldrons() {
        return bcauldrons;
    }
}

