/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelAsset;
import com.dre.brewery.BarrelFacing;
import com.dre.brewery.BarrelWoodType;
import org.bukkit.Material;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.jetbrains.annotations.NotNull;

public enum BarrelPart {
    BOTTOM_RIGHT(BarrelAsset.STAIRS, Bisected.Half.TOP, BarrelFacing.EAST),
    BOTTOM_LEFT(BarrelAsset.STAIRS, Bisected.Half.TOP, BarrelFacing.WEST),
    TOP_RIGHT(BarrelAsset.STAIRS, Bisected.Half.BOTTOM, BarrelFacing.EAST),
    TOP_LEFT(BarrelAsset.STAIRS, Bisected.Half.BOTTOM, BarrelFacing.WEST),
    BLOCK(BarrelAsset.PLANKS);

    private final BarrelAsset barrelAsset;
    private Bisected.Half half = null;
    private BarrelFacing untransformedFacing = null;

    private BarrelPart(BarrelAsset barrelAsset) {
        this.barrelAsset = barrelAsset;
    }

    public boolean matches(BarrelWoodType type, @NotNull BlockData actual, BarrelFacing facing) {
        Bisected bisected;
        Material actualType = actual.getMaterial();
        if (!BarrelAsset.isBarrelAsset(this.barrelAsset, actualType) || BarrelWoodType.fromMaterial(actualType) != type) {
            return false;
        }
        if (!(this.half == null || actual instanceof Bisected && (bisected = (Bisected)actual).getHalf() == this.half)) {
            return false;
        }
        if (this.untransformedFacing == null) {
            return true;
        }
        if (!(actual instanceof Directional)) {
            return false;
        }
        Directional directional = (Directional)actual;
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case BarrelFacing.SOUTH -> this.untransformedFacing.getFace().equals((Object)directional.getFacing());
            case BarrelFacing.EAST -> this.untransformedFacing.rotate90degrees().getFace().equals((Object)directional.getFacing());
            case BarrelFacing.NORTH -> this.untransformedFacing.rotate180degrees().getFace().equals((Object)directional.getFacing());
            case BarrelFacing.WEST -> this.untransformedFacing.rotate270degrees().getFace().equals((Object)directional.getFacing());
        };
    }

    private BarrelPart(BarrelAsset barrelAsset, Bisected.Half half, BarrelFacing untransformedFacing) {
        this.barrelAsset = barrelAsset;
        this.half = half;
        this.untransformedFacing = untransformedFacing;
    }
}

