/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.BSealer;
import com.dre.brewery.Barrel;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.api.addons.AddonManager;
import com.dre.brewery.commands.CommandManager;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.configurer.TranslationManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.depend.universalScheduler.UniversalScheduler;
import com.dre.brewery.depend.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.dre.brewery.integration.BlockLockerHook;
import com.dre.brewery.integration.Hook;
import com.dre.brewery.integration.LandsHook;
import com.dre.brewery.integration.PlaceholderAPIHook;
import com.dre.brewery.integration.barrel.BlockLockerBarrel;
import com.dre.brewery.integration.bstats.BreweryStats;
import com.dre.brewery.integration.bstats.BreweryXStats;
import com.dre.brewery.integration.listeners.ChestShopListener;
import com.dre.brewery.integration.listeners.IntegrationListener;
import com.dre.brewery.integration.listeners.ShopKeepersListener;
import com.dre.brewery.integration.listeners.SlimefunListener;
import com.dre.brewery.integration.listeners.movecraft.CraftDetectListener;
import com.dre.brewery.integration.listeners.movecraft.RotationListener;
import com.dre.brewery.integration.listeners.movecraft.SinkListener;
import com.dre.brewery.integration.listeners.movecraft.TranslationListener;
import com.dre.brewery.integration.listeners.movecraft.properties.BreweryProperties;
import com.dre.brewery.listeners.BlockListener;
import com.dre.brewery.listeners.CauldronListener;
import com.dre.brewery.listeners.EntityListener;
import com.dre.brewery.listeners.InventoryListener;
import com.dre.brewery.listeners.PlayerListener;
import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.ItemLoader;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.releases.ReleaseChecker;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class BreweryPlugin
extends JavaPlugin {
    private static AddonManager addonManager;
    private static TaskScheduler scheduler;
    private static BreweryPlugin instance;
    private static MinecraftVersion MCVersion;
    private static DataManager dataManager;
    private final Map<String, Function<ItemLoader, Ingredient>> ingredientLoaders = new HashMap<String, Function<ItemLoader, Ingredient>>();
    private BreweryStats breweryStats;

    public BreweryPlugin() {
        instance = this;
        this.migrateBreweryDataFolder();
        MCVersion = MinecraftVersion.getIt();
        scheduler = UniversalScheduler.getScheduler((Plugin)this);
        TranslationManager.newInstance(this.getDataFolder());
    }

    public void onLoad() {
        try {
            Class.forName("net.countercraft.movecraft.craft.type.property.Property");
            BreweryProperties.register();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getServer().getPluginManager().getPlugin("Lands") != null) {
            LandsHook.load();
        }
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_14)) {
            this.getServer().createBlockData(Material.CAMPFIRE);
        }
    }

    public void onEnable() {
        PlaceholderAPIHook placeholderAPIHook;
        CustomItem.registerItemLoader(this);
        SimpleItem.registerItemLoader(this);
        PluginItem.registerItemLoader(this);
        Config config = ConfigManager.getConfig(Config.class);
        if (config.isFirstCreation()) {
            config.onFirstCreation();
        }
        TranslationManager.getInstance().updateTranslationFiles();
        ConfigManager.newInstance(Lang.class, false);
        BSealer.registerRecipe();
        ConfigManager.registerDefaultPluginItems();
        addonManager = new AddonManager(this);
        addonManager.loadAddons();
        ConfigManager.loadCauldronIngredients();
        ConfigManager.loadRecipes();
        ConfigManager.loadDistortWords();
        ConfigManager.loadSeed();
        this.breweryStats = new BreweryStats();
        Logging.log("Minecraft version&7:&a " + MCVersion.getVersion());
        if (MCVersion == MinecraftVersion.UNKNOWN) {
            Logging.warningLog("This version of Minecraft is not known to Brewery! Please be wary of bugs or other issues that may occur in this version.");
        }
        try {
            dataManager = DataManager.createDataManager(config.getStorage());
        }
        catch (StorageInitException e) {
            Logging.errorLog("Failed to initialize DataManager!", e);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        DataManager.loadMiscData(dataManager.getBreweryMiscData());
        dataManager.getAllBarrels().thenAcceptAsync(barrels -> barrels.stream().filter(Objects::nonNull).forEach(Barrel::registerBarrel));
        BCauldron.getBcauldrons().putAll(dataManager.getAllCauldrons().stream().filter(Objects::nonNull).collect(Collectors.toMap(BCauldron::getBlock, Function.identity(), (existing, replacement) -> replacement)));
        BPlayer.getPlayers().putAll(dataManager.getAllPlayers().stream().filter(Objects::nonNull).collect(Collectors.toMap(BPlayer::getUuid, Function.identity())));
        Wakeup.getWakeups().addAll(dataManager.getAllWakeups().stream().filter(Objects::nonNull).toList());
        addonManager.enableAddons();
        this.breweryStats.setupBStats();
        new BreweryXStats().setupBStats();
        PluginCommand defaultCommand = this.getCommand("breweryx");
        defaultCommand.setExecutor((CommandExecutor)new CommandManager());
        try {
            Field bukkitCommandMap = this.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(this.getServer());
            for (String alias : config.getCommandAliases()) {
                commandMap.register(alias, "breweryx", (Command)defaultCommand);
            }
        }
        catch (Exception e) {
            Logging.errorLog("Failed to register command aliases!", e);
        }
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new BlockListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new IntegrationListener(), (Plugin)this);
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_9)) {
            pluginManager.registerEvents((Listener)new CauldronListener(), (Plugin)this);
        }
        if (Hook.CHESTSHOP.isEnabled() && BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_13)) {
            pluginManager.registerEvents((Listener)new ChestShopListener(), (Plugin)this);
        }
        if (Hook.SHOPKEEPERS.isEnabled()) {
            pluginManager.registerEvents((Listener)new ShopKeepersListener(), (Plugin)this);
        }
        if (Hook.SLIMEFUN.isEnabled() && BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_14)) {
            pluginManager.registerEvents((Listener)new SlimefunListener(), (Plugin)this);
        }
        if (Hook.MOVECRAFT.isEnabled()) {
            pluginManager.registerEvents((Listener)new CraftDetectListener(), (Plugin)this);
            pluginManager.registerEvents((Listener)new TranslationListener(), (Plugin)this);
            pluginManager.registerEvents((Listener)new RotationListener(), (Plugin)this);
            pluginManager.registerEvents((Listener)new SinkListener(), (Plugin)this);
        }
        BreweryPlugin.getScheduler().runTaskTimer(new BreweryRunnable(), 650L, 1200L);
        BreweryPlugin.getScheduler().runTaskTimer(new DrunkRunnable(), 120L, 120L);
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_9)) {
            BreweryPlugin.getScheduler().runTaskTimer(new CauldronParticles(), 1L, 1L);
        }
        if ((placeholderAPIHook = PlaceholderAPIHook.PLACEHOLDERAPI).isEnabled()) {
            placeholderAPIHook.getInstance().register();
        }
        Logging.log("Using scheduler&7: &a" + scheduler.getClass().getSimpleName());
        Logging.log("Environment&7: &a" + Logging.getEnvironmentAsString());
        if (!PaperLib.isPaper()) {
            Logging.log("&aBreweryX performs best on Paper-based servers. Please consider switching to Paper for the best experience. &7https://papermc.io");
        }
        Logging.log("BreweryX enabled!");
        ReleaseChecker releaseChecker = ReleaseChecker.getInstance();
        releaseChecker.checkForUpdate().thenAccept(updateAvailable -> releaseChecker.notify((CommandSender)Bukkit.getConsoleSender()));
    }

    public void onDisable() {
        if (addonManager != null) {
            addonManager.unloadAddons();
        }
        HandlerList.unregisterAll((Plugin)this);
        BreweryPlugin.getScheduler().cancelTasks((Plugin)this);
        if (dataManager != null) {
            dataManager.exit(true, false);
        }
        BSealer.unregisterRecipe();
        PlaceholderAPIHook placeholderAPIHook = PlaceholderAPIHook.PLACEHOLDERAPI;
        if (placeholderAPIHook.isEnabled()) {
            placeholderAPIHook.getInstance().unregister();
        }
        Logging.log("BreweryX disabled!");
    }

    public void registerForItemLoader(String saveID, Function<ItemLoader, Ingredient> loadFct) {
        this.ingredientLoaders.put(saveID, loadFct);
    }

    public void unRegisterItemLoader(String saveID) {
        this.ingredientLoaders.remove(saveID);
    }

    public void migrateBreweryDataFolder() {
        String pluginsFolder = this.getDataFolder().getParentFile().getPath();
        File breweryFolder = new File(pluginsFolder + File.separator + "Brewery");
        File breweryXFolder = new File(pluginsFolder + File.separator + "BreweryX");
        if (breweryFolder.exists() && !breweryXFolder.exists()) {
            File[] files;
            if (!breweryXFolder.exists()) {
                breweryXFolder.mkdirs();
            }
            if ((files = breweryFolder.listFiles()) != null) {
                for (File file : files) {
                    try {
                        Files.copy(file.toPath(), new File(breweryXFolder, file.getName()).toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        Logging.errorLog("Failed to move file: " + file.getName(), e);
                    }
                }
                Logging.log("&5Moved files from Brewery to BreweryX's data folder");
            }
        }
    }

    public Map<String, Function<ItemLoader, Ingredient>> getIngredientLoaders() {
        return this.ingredientLoaders;
    }

    public BreweryStats getBreweryStats() {
        return this.breweryStats;
    }

    public static AddonManager getAddonManager() {
        return addonManager;
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }

    public static BreweryPlugin getInstance() {
        return instance;
    }

    public static MinecraftVersion getMCVersion() {
        return MCVersion;
    }

    public static DataManager getDataManager() {
        return dataManager;
    }

    public static void setDataManager(DataManager dataManager) {
        BreweryPlugin.dataManager = dataManager;
    }

    public static class BreweryRunnable
    implements Runnable {
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            for (BCauldron bCauldron : BCauldron.bcauldrons.values()) {
                BreweryPlugin.getScheduler().runTask(bCauldron.getBlock().getLocation(), () -> {
                    if (!bCauldron.onUpdate()) {
                        BCauldron.bcauldrons.remove(bCauldron.getBlock());
                    }
                });
            }
            Barrel.onUpdate();
            if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_14)) {
                MCBarrel.onUpdate();
            }
            if (BlockLockerHook.BLOCKLOCKER.isEnabled()) {
                BlockLockerBarrel.clearBarrelSign();
            }
            BPlayer.onUpdate();
            dataManager.tryAutoSave();
            Logging.debugLog("BreweryRunnable: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public static class DrunkRunnable
    implements Runnable {
        @Override
        public void run() {
            if (!BPlayer.isEmpty()) {
                BPlayer.drunkenness();
            }
        }
    }

    public static class CauldronParticles
    implements Runnable {
        @Override
        public void run() {
            Config config = ConfigManager.getConfig(Config.class);
            if (!config.isEnableCauldronParticles()) {
                return;
            }
            if (config.isMinimalParticles() && BCauldron.particleRandom.nextFloat() > 0.5f) {
                return;
            }
            BCauldron.processCookEffects();
        }
    }
}

