/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.utility.Logging;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Barrel;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MCBarrel {
    public static final String TAG = "Btime";
    public static long mcBarrelTime;
    public static List<MCBarrel> openBarrels;
    private static final Config config;
    private static final Lang lang;
    private byte brews = (byte)-1;
    private final Inventory inv;
    private final int invSize;

    public MCBarrel(Inventory inv) {
        this.inv = inv;
        this.invSize = inv.getSize();
    }

    public void open() {
        InventoryHolder inventoryHolder;
        if (this.inv.getViewers().size() == 1 && (inventoryHolder = PaperLib.getHolder(this.inv, true).getHolder()) instanceof Barrel) {
            NamespacedKey key;
            Barrel barrel = (Barrel)inventoryHolder;
            PersistentDataContainer data = barrel.getPersistentDataContainer();
            if (!data.has(key = new NamespacedKey((Plugin)BreweryPlugin.getInstance(), TAG), PersistentDataType.LONG)) {
                key = new NamespacedKey("brewery", TAG.toLowerCase());
            }
            if (!data.has(key, PersistentDataType.LONG)) {
                return;
            }
            long time = mcBarrelTime - (Long)data.getOrDefault(key, PersistentDataType.LONG, (Object)mcBarrelTime);
            data.remove(key);
            barrel.update();
            Logging.debugLog("Barrel Time since last open: " + time);
            if (time > 0L) {
                this.brews = 0;
                if (this.inv.contains(Material.POTION)) {
                    long loadTime = System.nanoTime();
                    for (ItemStack item : this.inv.getContents()) {
                        Brew brew;
                        if (item == null || (brew = Brew.get(item)) == null || brew.isStatic()) continue;
                        if (this.brews < config.getMaxBrewsInMCBarrels() || config.getMaxBrewsInMCBarrels() < 0) {
                            brew.age(item, (float)time / 20.0f, BarrelWoodType.OAK);
                        }
                        this.brews = (byte)(this.brews + 1);
                    }
                    if (config.isDebug()) {
                        loadTime = System.nanoTime() - loadTime;
                        float ftime = (float)((double)loadTime / 1000000.0);
                        Logging.debugLog("opening MC Barrel with potions (" + ftime + "ms)");
                    }
                }
            }
        }
    }

    public void close() {
        if (this.inv.getViewers().size() == 1) {
            for (ItemStack item : this.inv.getContents()) {
                if (item == null || !Brew.isBrew(item)) continue;
                InventoryHolder inventoryHolder = PaperLib.getHolder(this.inv, true).getHolder();
                if (inventoryHolder instanceof Barrel) {
                    Barrel barrel = (Barrel)inventoryHolder;
                    PersistentDataContainer data = barrel.getPersistentDataContainer();
                    data.set(new NamespacedKey((Plugin)BreweryPlugin.getInstance(), TAG), PersistentDataType.LONG, (Object)mcBarrelTime);
                    barrel.update();
                }
                return;
            }
        }
    }

    public void countBrews() {
        this.brews = 0;
        for (ItemStack item : this.inv.getContents()) {
            if (item == null || !Brew.isBrew(item)) continue;
            this.brews = (byte)(this.brews + 1);
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public static void onUpdate() {
        if (config.isAgeInMCBarrels()) {
            ++mcBarrelTime;
        }
    }

    public void clickInv(InventoryClickEvent event) {
        if (config.getMaxBrewsInMCBarrels() >= this.invSize || config.getMaxBrewsInMCBarrels() < 0) {
            return;
        }
        boolean adding = false;
        switch (event.getAction()) {
            case PLACE_ALL: 
            case PLACE_ONE: 
            case PLACE_SOME: 
            case SWAP_WITH_CURSOR: {
                if (event.getCursor() == null || event.getClickedInventory() == null || event.getClickedInventory().getType() != InventoryType.BARREL || event.getCursor().getType() != Material.POTION || !Brew.isBrew(event.getCursor()) || event.getAction() == InventoryAction.SWAP_WITH_CURSOR && event.getCurrentItem() != null && event.getCurrentItem().getType() == Material.POTION && Brew.isBrew(event.getCurrentItem())) break;
                adding = true;
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                if (event.getCurrentItem() == null || event.getCurrentItem().getType() != Material.POTION || event.getClickedInventory() == null) break;
                if (event.getClickedInventory().getType() == InventoryType.BARREL) {
                    if (!Brew.isBrew(event.getCurrentItem())) break;
                    if (this.brews == -1) {
                        this.countBrews();
                    }
                    this.brews = (byte)(this.brews - 1);
                    break;
                }
                if (event.getClickedInventory().getType() != InventoryType.PLAYER || !Brew.isBrew(event.getCurrentItem())) break;
                adding = true;
                break;
            }
            case PICKUP_ALL: 
            case PICKUP_ONE: 
            case PICKUP_HALF: 
            case PICKUP_SOME: 
            case COLLECT_TO_CURSOR: {
                if (event.getCurrentItem() == null || event.getClickedInventory() == null || event.getClickedInventory().getType() != InventoryType.BARREL || event.getCurrentItem().getType() != Material.POTION || !Brew.isBrew(event.getCurrentItem())) break;
                if (this.brews == -1) {
                    this.countBrews();
                }
                this.brews = (byte)(this.brews - 1);
                break;
            }
            case HOTBAR_MOVE_AND_READD: 
            case HOTBAR_SWAP: {
                this.brews = (byte)-1;
                break;
            }
            default: {
                return;
            }
        }
        if (adding) {
            if (this.brews == -1) {
                this.countBrews();
            }
            if (this.brews >= config.getMaxBrewsInMCBarrels()) {
                event.setCancelled(true);
                lang.sendEntry((CommandSender)event.getWhoClicked(), "Player_BarrelFull", new Object[0]);
            } else {
                this.brews = (byte)(this.brews + 1);
            }
        }
    }

    static {
        openBarrels = new ArrayList<MCBarrel>();
        config = ConfigManager.getConfig(Config.class);
        lang = ConfigManager.getConfig(Lang.class);
    }
}

