/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Wakeup {
    private static final Lang lang = ConfigManager.getConfig(Lang.class);
    public static List<Wakeup> wakeups = new ArrayList<Wakeup>();
    public static BreweryPlugin breweryPlugin = BreweryPlugin.getInstance();
    public static int checkId = -1;
    public static Player checkPlayer = null;
    private final Location loc;
    private final UUID id;
    private boolean active = true;

    public Wakeup(Location loc) {
        this.loc = loc;
        this.id = UUID.randomUUID();
    }

    public Wakeup(Location loc, UUID id) {
        this.loc = loc;
        this.id = id;
    }

    public static Location getRandom(Location playerLoc) {
        if (wakeups.isEmpty()) {
            return null;
        }
        List<Wakeup> worldWakes = wakeups.stream().filter(w -> w.active).filter(w -> w.loc.getWorld().equals((Object)playerLoc.getWorld())).collect(Collectors.toList());
        if (worldWakes.isEmpty()) {
            return null;
        }
        Wakeup w1 = Wakeup.calcRandom(worldWakes);
        worldWakes.remove(w1);
        if (w1 == null) {
            return null;
        }
        while (!w1.check()) {
            Logging.errorLog("Please Check Wakeup-Location with id: &6" + wakeups.indexOf(w1));
            w1 = Wakeup.calcRandom(worldWakes);
            if (w1 == null) {
                return null;
            }
            worldWakes.remove(w1);
        }
        Wakeup w2 = Wakeup.calcRandom(worldWakes);
        if (w2 != null) {
            worldWakes.remove(w2);
            while (!w2.check()) {
                Logging.errorLog("Please Check Wakeup-Location with id: &6" + wakeups.indexOf(w2));
                w2 = Wakeup.calcRandom(worldWakes);
                if (w2 == null) {
                    return w1.loc;
                }
                worldWakes.remove(w2);
            }
            if (w1.loc.distanceSquared(playerLoc) > w2.loc.distanceSquared(playerLoc)) {
                return w2.loc;
            }
        }
        return w1.loc;
    }

    public static Wakeup calcRandom(List<Wakeup> worldWakes) {
        if (worldWakes.isEmpty()) {
            return null;
        }
        return worldWakes.get((int)Math.round(Math.random() * ((double)worldWakes.size() - 1.0)));
    }

    public static void set(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            wakeups.add(new Wakeup(player.getLocation()));
            lang.sendEntry(sender, "Player_WakeCreated", "" + (wakeups.size() - 1));
        } else {
            lang.sendEntry(sender, "Error_PlayerCommand", new Object[0]);
        }
    }

    public static void remove(CommandSender sender, int id) {
        if (wakeups.isEmpty() || id < 0 || id >= wakeups.size()) {
            lang.sendEntry(sender, "Player_WakeNotExist", "" + id);
            return;
        }
        Wakeup wakeup = wakeups.get(id);
        if (wakeup.active) {
            wakeup.active = false;
            lang.sendEntry(sender, "Player_WakeDeleted", "" + id);
        } else {
            lang.sendEntry(sender, "Player_WakeAlreadyDeleted", "" + id);
        }
    }

    public static void list(CommandSender sender, int page, String worldOnly) {
        if (wakeups.isEmpty()) {
            lang.sendEntry(sender, "Player_WakeNoPoints", new Object[0]);
            return;
        }
        ArrayList<String> locs = new ArrayList<String>();
        for (int id = 0; id < wakeups.size(); ++id) {
            Wakeup wakeup = wakeups.get(id);
            String s = "&m";
            if (wakeup.active) {
                s = "";
            }
            String world = wakeup.loc.getWorld().getName();
            if (worldOnly != null && !world.equalsIgnoreCase(worldOnly)) continue;
            int x = (int)wakeup.loc.getX();
            int y = (int)wakeup.loc.getY();
            int z = (int)wakeup.loc.getZ();
            locs.add("&6" + s + id + "&f" + s + ": " + world + " " + x + "," + y + "," + z);
        }
        BUtil.list(sender, locs, page);
    }

    public static void check(CommandSender sender, int id, boolean all) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!all) {
                if (wakeups.isEmpty() || id >= wakeups.size()) {
                    lang.sendEntry(sender, "Player_WakeNotExist", "" + id);
                    return;
                }
                Wakeup wakeup = wakeups.get(id);
                if (wakeup.check()) {
                    PaperLib.teleportAsync((Entity)player, wakeup.loc);
                } else {
                    String world = wakeup.loc.getWorld().getName();
                    int x = (int)wakeup.loc.getX();
                    int y = (int)wakeup.loc.getY();
                    int z = (int)wakeup.loc.getZ();
                    lang.sendEntry(sender, "Player_WakeFilled", "" + id, world, "" + x, "" + y, "" + z);
                }
            } else {
                if (wakeups.isEmpty()) {
                    lang.sendEntry(sender, "Player_WakeNoPoints", new Object[0]);
                    return;
                }
                if (checkPlayer != null && checkPlayer != player) {
                    checkId = -1;
                }
                checkPlayer = player;
                Wakeup.tpNext();
            }
        } else {
            lang.sendEntry(sender, "Error_PlayerCommand", new Object[0]);
        }
    }

    public boolean check() {
        return !this.loc.getBlock().getType().isSolid() && !this.loc.getBlock().getRelative(0, 1, 0).getType().isSolid();
    }

    public static void tpNext() {
        if (++checkId >= wakeups.size()) {
            lang.sendEntry((CommandSender)checkPlayer, "Player_WakeLast", new Object[0]);
            checkId = -1;
            checkPlayer = null;
            return;
        }
        Wakeup wakeup = wakeups.get(checkId);
        if (!wakeup.active) {
            Wakeup.tpNext();
            return;
        }
        String world = wakeup.loc.getWorld().getName();
        int x = (int)wakeup.loc.getX();
        int y = (int)wakeup.loc.getY();
        int z = (int)wakeup.loc.getZ();
        if (wakeup.check()) {
            lang.sendEntry((CommandSender)checkPlayer, "Player_WakeTeleport", checkId, world, "" + x, "" + y, "" + z);
            PaperLib.teleportAsync((Entity)checkPlayer, wakeup.loc);
        } else {
            lang.sendEntry((CommandSender)checkPlayer, "Player_WakeFilled", checkId, world, "" + x, "" + y, "" + z);
        }
        lang.sendEntry((CommandSender)checkPlayer, "Player_WakeHint1", new Object[0]);
        lang.sendEntry((CommandSender)checkPlayer, "Player_WakeHint2", new Object[0]);
    }

    public static void cancel(CommandSender sender) {
        if (checkPlayer != null) {
            checkPlayer = null;
            checkId = -1;
            lang.sendEntry(sender, "Player_WakeCancel", new Object[0]);
            return;
        }
        lang.sendEntry(sender, "Player_WakeNoCheck", new Object[0]);
    }

    public static void save(ConfigurationSection section, ConfigurationSection oldData) {
        BUtil.createWorldSections(section);
        if (!wakeups.isEmpty()) {
            Iterator<Wakeup> iter = wakeups.iterator();
            int id = 0;
            while (iter.hasNext()) {
                Wakeup wakeup = iter.next();
                if (wakeup.active) {
                    String worldName = wakeup.loc.getWorld().getName();
                    String prefix = worldName.startsWith("DXL_") ? BUtil.getDxlName(worldName) + "." + id : wakeup.loc.getWorld().getUID().toString() + "." + id;
                    section.set(prefix, (Object)(wakeup.loc.getX() + "/" + wakeup.loc.getY() + "/" + wakeup.loc.getZ() + "/" + wakeup.loc.getPitch() + "/" + wakeup.loc.getYaw()));
                }
                ++id;
            }
        }
        if (oldData != null) {
            for (String uuid : oldData.getKeys(false)) {
                if (section.contains(uuid)) continue;
                section.set(uuid, oldData.get(uuid));
            }
        }
    }

    public static void onUnload(World world) {
        wakeups.removeIf(wakeup -> wakeup.loc.getWorld().equals((Object)world));
    }

    public static void unloadWorlds() {
        List worlds = BreweryPlugin.getInstance().getServer().getWorlds();
        wakeups.removeIf(wakeup -> !worlds.contains(wakeup.loc.getWorld()));
    }

    public Location getLoc() {
        return this.loc;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public static List<Wakeup> getWakeups() {
        return wakeups;
    }
}

