/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.PermissionUtil;
import com.dre.brewery.utility.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class CommandUtil {
    private static final BreweryPlugin plugin = BreweryPlugin.getInstance();
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final Lang lang = ConfigManager.getConfig(Lang.class);
    private static Set<Tuple<String, String>> mainSet;
    private static Set<Tuple<String, String>> altSet;
    private static final String[] QUALITY;

    public static void cmdHelp(CommandSender sender, String[] args) {
        int page = 1;
        if (args.length > 1) {
            page = BUtil.parseInt(args[1]).orElse(1);
        }
        ArrayList<String> commands = CommandUtil.getCommands(sender);
        if (page == 1) {
            Logging.msg(sender, "&6" + plugin.getDescription().getName() + " v" + plugin.getDescription().getVersion());
        }
        BUtil.list(sender, commands, page);
    }

    @Nullable
    public static Tuple<Brew, Player> getFromCommand(CommandSender sender, String[] args) {
        String name;
        if (args.length < 2) {
            return null;
        }
        int quality = 10;
        boolean hasQuality = false;
        String pName = null;
        if (args.length > 2) {
            quality = BUtil.getRandomIntInRange(args[args.length - 1]);
            if (quality <= 0 || quality > 10) {
                pName = args[args.length - 1];
                if (args.length > 3) {
                    quality = BUtil.getRandomIntInRange(args[args.length - 2]);
                }
            }
            if (quality > 0 && quality <= 10) {
                hasQuality = true;
            } else {
                quality = 10;
            }
        }
        Player player = null;
        if (pName != null) {
            player = plugin.getServer().getPlayer(pName);
        }
        if (!(sender instanceof Player) && player == null) {
            lang.sendEntry(sender, "Error_PlayerCommand", new Object[0]);
            return null;
        }
        if (player == null) {
            player = (Player)sender;
            pName = null;
        }
        int stringLength = args.length - 1;
        if (pName != null) {
            --stringLength;
        }
        if (hasQuality) {
            --stringLength;
        }
        if (stringLength > 1) {
            StringBuilder builder = new StringBuilder(args[1]);
            for (int i = 2; i < stringLength + 1; ++i) {
                builder.append(" ").append(args[i]);
            }
            name = builder.toString();
        } else {
            name = args[1];
        }
        name = name.replaceAll("\"", "");
        BRecipe recipe = BRecipe.getMatching(name);
        if (recipe != null) {
            return new Tuple<Brew, Player>(recipe.createBrew(quality), player);
        }
        lang.sendEntry(sender, "Error_NoBrewName", name);
        return null;
    }

    public static ArrayList<String> getCommands(CommandSender sender) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(lang.getEntry("Help_Help", new Object[0]));
        PermissionUtil.evaluateExtendedPermissions(sender);
        if (PermissionUtil.BPermission.INFO.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Info", new Object[0]));
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_13) && PermissionUtil.BPermission.SEAL.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Seal", new Object[0]));
        }
        if (PermissionUtil.BPermission.UNLABEL.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_UnLabel", new Object[0]));
        }
        if (PermissionUtil.noExtendedPermissions(sender)) {
            return cmds;
        }
        if (PermissionUtil.BPermission.INFO_OTHER.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_InfoOther", new Object[0]));
        }
        if (PermissionUtil.BPermission.CREATE.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Create", new Object[0]));
            cmds.add(lang.getEntry("Help_Give", new Object[0]));
            cmds.add(lang.getEntry("Help_Distill", new Object[0]));
            cmds.add(lang.getEntry("Help_Age", new Object[0]));
            cmds.add(lang.getEntry("Help_Simulate", new Object[0]));
        }
        if (PermissionUtil.BPermission.DRINK.checkCached(sender) || PermissionUtil.BPermission.DRINK_OTHER.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Drink", new Object[0]));
        }
        if (PermissionUtil.BPermission.RELOAD.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Configname", new Object[0]));
            cmds.add(lang.getEntry("Help_Reload", new Object[0]));
        }
        if (PermissionUtil.BPermission.PUKE.checkCached(sender) || PermissionUtil.BPermission.PUKE_OTHER.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Puke", new Object[0]));
        }
        if (PermissionUtil.BPermission.WAKEUP.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Wakeup", new Object[0]));
            cmds.add(lang.getEntry("Help_WakeupList", new Object[0]));
            cmds.add(lang.getEntry("Help_WakeupCheck", new Object[0]));
            cmds.add(lang.getEntry("Help_WakeupCheckSpecific", new Object[0]));
            cmds.add(lang.getEntry("Help_WakeupAdd", new Object[0]));
            cmds.add(lang.getEntry("Help_WakeupRemove", new Object[0]));
        }
        if (PermissionUtil.BPermission.STATIC.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Static", new Object[0]));
        }
        if (PermissionUtil.BPermission.SET.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Set", new Object[0]));
        }
        if (PermissionUtil.BPermission.COPY.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Copy", new Object[0]));
        }
        if (PermissionUtil.BPermission.DELETE.checkCached(sender)) {
            cmds.add(lang.getEntry("Help_Delete", new Object[0]));
        }
        return cmds;
    }

    public static List<String> recipeNamesAndIds(String[] args) {
        if (args.length == 2) {
            return CommandUtil.recipeNamesAndIds(args[1]);
        }
        if (args[args.length - 1].matches("10|[1-9]")) {
            return null;
        }
        return CommandUtil.filterWithInput(QUALITY, args[args.length - 1]);
    }

    public static List<String> recipeNamesAndIds(String arg) {
        if (mainSet == null) {
            mainSet = new HashSet<Tuple<String, String>>();
            altSet = new HashSet<Tuple<String, String>>();
            for (BRecipe recipe : BRecipe.getAllRecipes()) {
                mainSet.addAll(CommandUtil.createLookupFromName(recipe.getName(5)));
                HashSet<String> altNames = new HashSet<String>(3);
                altNames.add(recipe.getName(1));
                altNames.add(recipe.getName(10));
                if (recipe.getId() != null) {
                    altNames.add(recipe.getId());
                }
                for (String altName : altNames) {
                    altSet.addAll(CommandUtil.createLookupFromName(altName));
                }
            }
        }
        String input = arg.toLowerCase();
        List<String> options = mainSet.stream().filter(s -> ((String)s.a()).startsWith(input)).map(Tuple::second).collect(Collectors.toList());
        if (options.isEmpty()) {
            options = altSet.stream().filter(s -> ((String)s.a()).startsWith(input)).map(Tuple::second).collect(Collectors.toList());
        }
        return options;
    }

    private static List<Tuple<String, String>> createLookupFromName(String name) {
        return Arrays.stream(name.split(" ")).map(word -> new Tuple<String, String>(word.toLowerCase(), name)).collect(Collectors.toList());
    }

    public static List<String> filterWithInput(String[] options, String input) {
        return Arrays.stream(options).filter(s -> s.startsWith(input)).collect(Collectors.toList());
    }

    public static void reloadTabCompleter() {
        mainSet = null;
        altSet = null;
    }

    static {
        QUALITY = new String[]{"1", "10"};
    }
}

