/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.configurer;

import com.dre.brewery.configuration.configurer.Translation;
import com.dre.brewery.utility.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class ConfigTranslations {
    private final Map<String, Object> translations;

    public ConfigTranslations(Translation activeTranslation) {
        this(activeTranslation, new Yaml());
    }

    public ConfigTranslations(Translation activeTranslation, Yaml yamlInstance) {
        try (InputStream inputStream = ConfigTranslations.class.getResourceAsStream("/config-langs/" + activeTranslation.fileName());){
            if (inputStream != null) {
                this.translations = (Map)yamlInstance.load(inputStream);
                return;
            }
            try (InputStream defaultInputStream = ConfigTranslations.class.getResourceAsStream("/config-langs/" + Translation.EN.fileName());){
                Logging.log("Could not find config translation, using default");
                if (defaultInputStream == null) {
                    throw new IOException("Couldn't find default translation file");
                }
                this.translations = (Map)yamlInstance.load(defaultInputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public String getTranslation(String key) {
        try {
            if (this.translations == null) {
                return null;
            }
            if (!key.contains(".")) {
                return (String)this.translations.get(key);
            }
            String[] keys = key.split("\\.");
            Map current = this.translations;
            for (int i = 0; i < keys.length - 1; ++i) {
                if ((current = (Map)current.get(keys[i])) != null) continue;
                return null;
            }
            return (String)current.get(keys[keys.length - 1]);
        }
        catch (Exception e) {
            Logging.errorLog("Error while getting translation for key: " + key, e);
            return null;
        }
    }
}

