/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.files;

import com.dre.brewery.configuration.AbstractOkaeriConfigFile;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.annotation.LocalizedComment;
import com.dre.brewery.configuration.annotation.OkaeriConfigFileOptions;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.sector.CustomItemsSector;
import com.dre.brewery.configuration.sector.capsule.ConfigCustomItem;
import com.dre.brewery.depend.okaeri.configs.annotation.Header;
import com.dre.brewery.recipe.RecipeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Header(value={"!!! IMPORTANT: BreweryX configuration files do NOT support external comments! If you add any comments, they will be overwritten !!!"})
@OkaeriConfigFileOptions(value="custom-items.yml")
public class CustomItemsFile
extends AbstractOkaeriConfigFile {
    @LocalizedComment(value={"customItemsFile.header"})
    private Map<String, ConfigCustomItem> customItems = new CustomItemsSector().getCapsules();

    public Map<String, ConfigCustomItem> getCustomItems() {
        HashMap<String, ConfigCustomItem> map = new HashMap<String, ConfigCustomItem>(this.customItems);
        map.putAll(ConfigManager.getConfig(Config.class).getCustomItems());
        return map;
    }

    public List<RecipeItem> getRecipeItems() {
        ArrayList<RecipeItem> recipeItems = new ArrayList<RecipeItem>();
        for (Map.Entry<String, ConfigCustomItem> entry : this.getCustomItems().entrySet()) {
            ConfigCustomItem customItem = entry.getValue();
            recipeItems.add(RecipeItem.fromConfigCustom(entry.getKey(), customItem));
        }
        return recipeItems;
    }

    public void setCustomItems(Map<String, ConfigCustomItem> customItems) {
        this.customItems = customItems;
    }
}

