/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.files;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.AbstractOkaeriConfigFile;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.annotation.DefaultCommentSpace;
import com.dre.brewery.configuration.annotation.OkaeriConfigFileOptions;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.depend.okaeri.configs.annotation.Comment;
import com.dre.brewery.depend.okaeri.configs.annotation.CustomKey;
import com.dre.brewery.depend.okaeri.configs.annotation.Exclude;
import com.dre.brewery.depend.okaeri.configs.annotation.Header;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

@OkaeriConfigFileOptions(useLangFileName=true, removeOrphans=true)
@Header(value={"!!! IMPORTANT: BreweryX configuration files do NOT support external comments! If you add any comments, they will be overwritten !!!", "Translations for BreweryX"})
@DefaultCommentSpace(value=1)
public class Lang
extends AbstractOkaeriConfigFile {
    @Exclude
    private final transient Config config = ConfigManager.getConfig(Config.class);
    @Exclude
    private transient Map<String, Object> mappedEntries;
    @Comment(value={"Brew"})
    @CustomKey(value="Brew_Alc")
    private String brewAlc;
    @CustomKey(value="Brew_Alcoholic")
    private String brewAlcoholic;
    @CustomKey(value="Brew_BadPotion")
    private String brewBadPotion;
    @CustomKey(value="Brew_BarrelRiped")
    private String brewBarrelRiped;
    @CustomKey(value="Brew_Brewer")
    private String brewBrewer;
    @CustomKey(value="Brew_DistillUndefined")
    private String brewDistillUndefined;
    @CustomKey(value="Brew_Distilled")
    private String brewDistilled;
    @CustomKey(value="Brew_fermented")
    private String brewFermented;
    @CustomKey(value="Brew_HundredsOfYears")
    private String brewHundredsOfYears;
    @CustomKey(value="Brew_Ingredients")
    private String brewIngredients;
    @CustomKey(value="Brew_LessDistilled")
    private String brewLessDistilled;
    @CustomKey(value="Brew_minute")
    private String brewMinute;
    @CustomKey(value="Brew_MinutePluralPostfix")
    private String brewMinutePluralPostfix;
    @CustomKey(value="Brew_OneYear")
    private String brewOneYear;
    @CustomKey(value="Brew_times")
    private String brewTimes;
    @CustomKey(value="Brew_ThickBrew")
    private String brewThickBrew;
    @CustomKey(value="Brew_Undefined")
    private String brewUndefined;
    @CustomKey(value="Brew_Woodtype")
    private String brewWoodtype;
    @CustomKey(value="Brew_Years")
    private String brewYears;
    @Comment(value={"Brew Defects"})
    @CustomKey(value="Defect_BadAged")
    private List<String> defectBadAged;
    @CustomKey(value="Defect_BadDistill")
    private List<String> defectBadDistill;
    @CustomKey(value="Defect_HighCount")
    private List<String> defectHighCount;
    @CustomKey(value="Defect_LowCount")
    private List<String> defectLowCount;
    @CustomKey(value="Defect_MissingIngredient")
    private List<String> defectMissingIngredient;
    @CustomKey(value="Defect_NeedsDistill")
    private List<String> defectNeedsDistill;
    @CustomKey(value="Defect_NeedsDistillAlc")
    private List<String> defectNeedsDistillAlc;
    @CustomKey(value="Defect_NoRecipesRegistered")
    private List<String> defectNoRecipesRegistered;
    @CustomKey(value="Defect_OverAged")
    private List<String> defectOverAged;
    @CustomKey(value="Defect_OverAgedAlc")
    private List<String> defectOverAgedAlc;
    @CustomKey(value="Defect_Overcooked")
    private List<String> defectOvercooked;
    @CustomKey(value="Defect_UnderAged")
    private List<String> defectUnderAged;
    @CustomKey(value="Defect_Uncooked")
    private List<String> defectUncooked;
    @CustomKey(value="Defect_WrongIngredient")
    private List<String> defectWrongIngredient;
    @CustomKey(value="Defect_WrongWood")
    private List<String> defectWrongWood;
    @Comment(value={"CMD"})
    @CustomKey(value="CMD_Aged")
    private String cmdAged;
    @CustomKey(value="CMD_Configname")
    private String cmdConfigname;
    @CustomKey(value="CMD_Configname_Error")
    private String cmdConfignameError;
    @CustomKey(value="CMD_Copy_Error")
    private String cmdCopyError;
    @CustomKey(value="CMD_Created")
    private String cmdCreated;
    @CustomKey(value="CMD_Cannot_Distill")
    private String cmdCannotDistill;
    @CustomKey(value="CMD_Distill_Ruined")
    private String cmdDistillRuined;
    @CustomKey(value="CMD_Distilled")
    private String cmdDistilled;
    @CustomKey(value="CMD_Drink")
    private String cmdDrink;
    @CustomKey(value="CMD_DrinkOther")
    private String cmdDrinkOther;
    @CustomKey(value="CMD_Duplicate_Option")
    private String cmdDuplicateOption;
    @CustomKey(value="CMD_Info_Drunk")
    private String cmdInfoDrunk;
    @CustomKey(value="CMD_Info_NotDrunk")
    private String cmdInfoNotDrunk;
    @CustomKey(value="CMD_Ingredient")
    private String cmdIngredient;
    @CustomKey(value="CMD_Invalid_Age_Time")
    private String cmdInvalidAgeTime;
    @CustomKey(value="CMD_Invalid_Cook_Time")
    private String cmdInvalidCookTime;
    @CustomKey(value="CMD_Invalid_Distill_Runs")
    private String cmdInvalidDistillRuns;
    @CustomKey(value="CMD_Invalid_Ingredient")
    private String cmdInvalidIngredient;
    @CustomKey(value="CMD_Invalid_Option")
    private String cmdInvalidOption;
    @CustomKey(value="CMD_Invalid_Wood_Type")
    private String cmdInvalidWoodType;
    @CustomKey(value="CMD_Missing_Cook_Time")
    private String cmdMissingCookTime;
    @CustomKey(value="CMD_Missing_Ingredients")
    private String cmdMissingIngredients;
    @CustomKey(value="CMD_NonStatic")
    private String cmdNonStatic;
    @CustomKey(value="CMD_Player")
    private String cmdPlayer;
    @CustomKey(value="CMD_Player_Error")
    private String cmdPlayerError;
    @CustomKey(value="CMD_Reload")
    private String cmdReload;
    @CustomKey(value="CMD_Set")
    private String cmdSet;
    @CustomKey(value="CMD_Simulated")
    private String cmdSimulated;
    @CustomKey(value="CMD_Static")
    private String cmdStatic;
    @CustomKey(value="CMD_UnLabel")
    private String cmdUnLabel;
    @CustomKey(value="CMD_Age_Ruined")
    private String cmdAgeRuined;
    @Comment(value={"Error"})
    @CustomKey(value="Error_AlreadyUnlabeled")
    private String errorAlreadyUnlabeled;
    @CustomKey(value="Error_ConfigUpdate")
    private String errorConfigUpdate;
    @CustomKey(value="Error_InvalidAmount")
    private String errorInvalidAmount;
    @CustomKey(value="Error_InvalidMaterial")
    private String errorInvalidMaterial;
    @CustomKey(value="Error_InvalidPluginItem")
    private String errorInvalidPluginItem;
    @CustomKey(value="Error_ItemNotPotion")
    private String errorItemNotPotion;
    @CustomKey(value="Error_MissingBarrelType")
    private String errorMissingBarrelType;
    @CustomKey(value="Error_NoBarrelAccess")
    private String errorNoBarrelAccess;
    @CustomKey(value="Error_NoBrewName")
    private String errorNoBrewName;
    @CustomKey(value="Error_NoPermissions")
    private String errorNoPermissions;
    @CustomKey(value="Error_NoPlayer")
    private String errorNoPlayer;
    @CustomKey(value="Error_PlayerCommand")
    private String errorPlayerCommand;
    @CustomKey(value="Error_Recipeload")
    private String errorRecipeload;
    @CustomKey(value="Error_SealedAlwaysStatic")
    private String errorSealedAlwaysStatic;
    @CustomKey(value="Error_SealingTableDisabled")
    private String errorSealingTableDisabled;
    @CustomKey(value="Error_ShowHelp")
    private String errorShowHelp;
    @CustomKey(value="Error_UnknownCommand")
    private String errorUnknownCommand;
    @CustomKey(value="Error_YmlRead")
    private String errorYmlRead;
    @Comment(value={"Etc"})
    @CustomKey(value="Etc_Barrel")
    private String etcBarrel;
    @CustomKey(value="Etc_LandsFlag_Description")
    private String etcLandsFlagDescription;
    @CustomKey(value="Etc_LandsFlag_Title")
    private String etcLandsFlagTitle;
    @CustomKey(value="Etc_NewRelease")
    private String etcNewRelease;
    @CustomKey(value="Etc_Page")
    private String etcPage;
    @CustomKey(value="Etc_SealingTable")
    private String etcSealingTable;
    @CustomKey(value="Etc_Usage")
    private String etcUsage;
    @Comment(value={"Help"})
    @CustomKey(value="Help_Age")
    private String helpAge;
    @CustomKey(value="Help_Configname")
    private String helpConfigname;
    @CustomKey(value="Help_Copy")
    private String helpCopy;
    @CustomKey(value="Help_Create")
    private String helpCreate;
    @CustomKey(value="Help_Delete")
    private String helpDelete;
    @CustomKey(value="Help_Distill")
    private String helpDistill;
    @CustomKey(value="Help_Drink")
    private String helpDrink;
    @CustomKey(value="Help_Give")
    private String helpGive;
    @CustomKey(value="Help_Help")
    private String helpHelp;
    @CustomKey(value="Help_Info")
    private String helpInfo;
    @CustomKey(value="Help_InfoOther")
    private String helpInfoOther;
    @CustomKey(value="Help_Puke")
    private String helpPuke;
    @CustomKey(value="Help_Reload")
    private String helpReload;
    @CustomKey(value="Help_Seal")
    private String helpSeal;
    @CustomKey(value="Help_Set")
    private String helpSet;
    @CustomKey(value="Help_Simulate")
    private String helpSimulate;
    @CustomKey(value="Help_Simulate_Age")
    private String helpSimulateAge;
    @CustomKey(value="Help_Simulate_Brewer")
    private String helpSimulateBrewer;
    @CustomKey(value="Help_Simulate_Cook")
    private String helpSimulateCook;
    @CustomKey(value="Help_Simulate_Distill")
    private String helpSimulateDistill;
    @CustomKey(value="Help_Simulate_Options")
    private String helpSimulateOptions;
    @CustomKey(value="Help_Simulate_Player")
    private String helpSimulatePlayer;
    @CustomKey(value="Help_Simulate_Recipe")
    private String helpSimulateRecipe;
    @CustomKey(value="Help_Static")
    private String helpStatic;
    @CustomKey(value="Help_UnLabel")
    private String helpUnLabel;
    @CustomKey(value="Help_Wakeup")
    private String helpWakeup;
    @CustomKey(value="Help_WakeupAdd")
    private String helpWakeupAdd;
    @CustomKey(value="Help_WakeupCheck")
    private String helpWakeupCheck;
    @CustomKey(value="Help_WakeupCheckSpecific")
    private String helpWakeupCheckSpecific;
    @CustomKey(value="Help_WakeupList")
    private String helpWakeupList;
    @CustomKey(value="Help_WakeupRemove")
    private String helpWakeupRemove;
    @Comment(value={"Perms"})
    @CustomKey(value="Perms_NoBarrelCreate")
    private String permsNoBarrelCreate;
    @CustomKey(value="Perms_NoBigBarrelCreate")
    private String permsNoBigBarrelCreate;
    @CustomKey(value="Perms_NoCauldronFill")
    private String permsNoCauldronFill;
    @CustomKey(value="Perms_NoCauldronInsert")
    private String permsNoCauldronInsert;
    @CustomKey(value="Perms_NoSmallBarrelCreate")
    private String permsNoSmallBarrelCreate;
    @Comment(value={"Player"})
    @CustomKey(value="Player_BarrelCreated")
    private String playerBarrelCreated;
    @CustomKey(value="Player_BarrelFull")
    private String playerBarrelFull;
    @CustomKey(value="Player_CantDrink")
    private String playerCantDrink;
    @CustomKey(value="Player_CauldronInfo1")
    private String playerCauldronInfo1;
    @CustomKey(value="Player_CauldronInfo2")
    private String playerCauldronInfo2;
    @CustomKey(value="Player_DrunkPassOut")
    private String playerDrunkPassOut;
    @CustomKey(value="Player_Drunkeness")
    private String playerDrunkeness;
    @CustomKey(value="Player_Hangover")
    private String playerHangover;
    @CustomKey(value="Player_LoginDeny")
    private String playerLoginDeny;
    @CustomKey(value="Player_LoginDenyLong")
    private String playerLoginDenyLong;
    @CustomKey(value="Player_ShopSealBrew")
    private String playerShopSealBrew;
    @CustomKey(value="Player_TriedToSay")
    private String playerTriedToSay;
    @CustomKey(value="Player_Wake")
    private String playerWake;
    @CustomKey(value="Player_WakeAlreadyDeleted")
    private String playerWakeAlreadyDeleted;
    @CustomKey(value="Player_WakeCancel")
    private String playerWakeCancel;
    @CustomKey(value="Player_WakeCreated")
    private String playerWakeCreated;
    @CustomKey(value="Player_WakeDeleted")
    private String playerWakeDeleted;
    @CustomKey(value="Player_WakeFilled")
    private String playerWakeFilled;
    @CustomKey(value="Player_WakeHint1")
    private String playerWakeHint1;
    @CustomKey(value="Player_WakeHint2")
    private String playerWakeHint2;
    @CustomKey(value="Player_WakeLast")
    private String playerWakeLast;
    @CustomKey(value="Player_WakeNoCheck")
    private String playerWakeNoCheck;
    @CustomKey(value="Player_WakeNoPoints")
    private String playerWakeNoPoints;
    @CustomKey(value="Player_WakeNotExist")
    private String playerWakeNotExist;
    @CustomKey(value="Player_WakeTeleport")
    private String playerWakeTeleport;

    @Override
    public void reload() {
        if (this.blankInstance) {
            super.reload();
            return;
        }
        Path bind = ConfigManager.getFilePath(Lang.class);
        File file = bind.toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        this.setBindFile(bind);
        this.load(this.update);
        this.mapStrings();
    }

    public void updateMissingValuesFrom(@Nullable Lang other) {
        if (other == null) {
            return;
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.getType() != String.class && field.getType() != List.class) continue;
            try {
                Object thisValue = field.get(this);
                Object otherValue = field.get(other);
                if (thisValue != null || otherValue == null) continue;
                field.set(this, otherValue);
            }
            catch (IllegalAccessException e) {
                Logging.errorLog("Lang failed to get a field value! &6(" + field.getName() + ")", e);
            }
        }
    }

    public void mapStrings() {
        BreweryPlugin plugin = BreweryPlugin.getInstance();
        Logging.log("Using language&7: &a" + String.valueOf(this.getBindFile().getFileName()));
        this.mappedEntries = new HashMap<String, Object>();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.getType() != String.class && field.getType() != List.class) continue;
            try {
                CustomKey customKey = field.getAnnotation(CustomKey.class);
                if (customKey != null) {
                    this.mappedEntries.put(customKey.value(), field.get(this));
                    continue;
                }
                this.mappedEntries.put(field.getName(), field.get(this));
            }
            catch (IllegalAccessException e) {
                Logging.errorLog("Lang failed to get a field value! &6(" + field.getName() + ")", e);
            }
        }
    }

    public void sendEntry(CommandSender recipient, String key, Object ... args) {
        recipient.sendMessage(BUtil.color(this.config.getPluginPrefix() + this.getEntry(key, false, args)));
    }

    public void logEntry(Logging.LogLevel level, String key, Object ... args) {
        Logging.log(level, this.getEntry(key, false, args));
    }

    public String getEntry(String key, Object ... args) {
        return this.getEntry(key, true, args);
    }

    public String getEntry(String key, boolean color, Object ... args) {
        Object entry;
        if (this.mappedEntries == null) {
            this.mapStrings();
        }
        Object msg = (entry = this.mappedEntries.get(key)) instanceof String ? Lang.format((String)entry, args) : (entry instanceof List ? "&c[LanguageReader] Config entry for key '" + key + "' is a list!" : "&c[LanguageReader] Failed to retrieve a config entry for key '" + key + "'!");
        return color ? BUtil.color((String)msg) : msg;
    }

    public List<String> getEntries(String key, Object ... args) {
        return this.getEntries(key, true, args);
    }

    public List<String> getEntries(String key, boolean color, Object ... args) {
        Object entry;
        if (this.mappedEntries == null) {
            this.mapStrings();
        }
        List<CallSite> msgs = (entry = this.mappedEntries.get(key)) instanceof String ? List.of((String)entry) : (entry instanceof List ? (List<CallSite>)entry : List.of("&c[LanguageReader] Failed to retrieve a config entry for key '" + key + "'!"));
        return msgs.stream().map(s -> Lang.format(s, args)).map(s -> color ? BUtil.color(s) : s).toList();
    }

    private static String format(String entry, Object ... args) {
        int i = 0;
        for (Object arg : args) {
            if (arg == null) continue;
            entry = entry.replace("&v" + ++i, arg.toString());
        }
        return entry;
    }
}

