/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBinary;
import com.dre.brewery.depend.bson.BsonBoolean;
import com.dre.brewery.depend.bson.BsonDateTime;
import com.dre.brewery.depend.bson.BsonDbPointer;
import com.dre.brewery.depend.bson.BsonDecimal128;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonDouble;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonInt64;
import com.dre.brewery.depend.bson.BsonInvalidOperationException;
import com.dre.brewery.depend.bson.BsonJavaScript;
import com.dre.brewery.depend.bson.BsonJavaScriptWithScope;
import com.dre.brewery.depend.bson.BsonNull;
import com.dre.brewery.depend.bson.BsonNumber;
import com.dre.brewery.depend.bson.BsonObjectId;
import com.dre.brewery.depend.bson.BsonRegularExpression;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonSymbol;
import com.dre.brewery.depend.bson.BsonTimestamp;
import com.dre.brewery.depend.bson.BsonType;

public abstract class BsonValue {
    BsonValue() {
    }

    public abstract BsonType getBsonType();

    public BsonDocument asDocument() {
        this.throwIfInvalidType(BsonType.DOCUMENT);
        return (BsonDocument)this;
    }

    public BsonArray asArray() {
        this.throwIfInvalidType(BsonType.ARRAY);
        return (BsonArray)this;
    }

    public BsonString asString() {
        this.throwIfInvalidType(BsonType.STRING);
        return (BsonString)this;
    }

    public BsonNumber asNumber() {
        if (!this.isNumber()) {
            throw new BsonInvalidOperationException(String.format("Value expected to be of a numerical BSON type is of unexpected type %s", new Object[]{this.getBsonType()}));
        }
        return (BsonNumber)this;
    }

    public BsonInt32 asInt32() {
        this.throwIfInvalidType(BsonType.INT32);
        return (BsonInt32)this;
    }

    public BsonInt64 asInt64() {
        this.throwIfInvalidType(BsonType.INT64);
        return (BsonInt64)this;
    }

    public BsonDecimal128 asDecimal128() {
        this.throwIfInvalidType(BsonType.DECIMAL128);
        return (BsonDecimal128)this;
    }

    public BsonDouble asDouble() {
        this.throwIfInvalidType(BsonType.DOUBLE);
        return (BsonDouble)this;
    }

    public BsonBoolean asBoolean() {
        this.throwIfInvalidType(BsonType.BOOLEAN);
        return (BsonBoolean)this;
    }

    public BsonObjectId asObjectId() {
        this.throwIfInvalidType(BsonType.OBJECT_ID);
        return (BsonObjectId)this;
    }

    public BsonDbPointer asDBPointer() {
        this.throwIfInvalidType(BsonType.DB_POINTER);
        return (BsonDbPointer)this;
    }

    public BsonTimestamp asTimestamp() {
        this.throwIfInvalidType(BsonType.TIMESTAMP);
        return (BsonTimestamp)this;
    }

    public BsonBinary asBinary() {
        this.throwIfInvalidType(BsonType.BINARY);
        return (BsonBinary)this;
    }

    public BsonDateTime asDateTime() {
        this.throwIfInvalidType(BsonType.DATE_TIME);
        return (BsonDateTime)this;
    }

    public BsonSymbol asSymbol() {
        this.throwIfInvalidType(BsonType.SYMBOL);
        return (BsonSymbol)this;
    }

    public BsonRegularExpression asRegularExpression() {
        this.throwIfInvalidType(BsonType.REGULAR_EXPRESSION);
        return (BsonRegularExpression)this;
    }

    public BsonJavaScript asJavaScript() {
        this.throwIfInvalidType(BsonType.JAVASCRIPT);
        return (BsonJavaScript)this;
    }

    public BsonJavaScriptWithScope asJavaScriptWithScope() {
        this.throwIfInvalidType(BsonType.JAVASCRIPT_WITH_SCOPE);
        return (BsonJavaScriptWithScope)this;
    }

    public boolean isNull() {
        return this instanceof BsonNull;
    }

    public boolean isDocument() {
        return this instanceof BsonDocument;
    }

    public boolean isArray() {
        return this instanceof BsonArray;
    }

    public boolean isString() {
        return this instanceof BsonString;
    }

    public boolean isNumber() {
        return this instanceof BsonNumber;
    }

    public boolean isInt32() {
        return this instanceof BsonInt32;
    }

    public boolean isInt64() {
        return this instanceof BsonInt64;
    }

    public boolean isDecimal128() {
        return this instanceof BsonDecimal128;
    }

    public boolean isDouble() {
        return this instanceof BsonDouble;
    }

    public boolean isBoolean() {
        return this instanceof BsonBoolean;
    }

    public boolean isObjectId() {
        return this instanceof BsonObjectId;
    }

    public boolean isDBPointer() {
        return this instanceof BsonDbPointer;
    }

    public boolean isTimestamp() {
        return this instanceof BsonTimestamp;
    }

    public boolean isBinary() {
        return this instanceof BsonBinary;
    }

    public boolean isDateTime() {
        return this instanceof BsonDateTime;
    }

    public boolean isSymbol() {
        return this instanceof BsonSymbol;
    }

    public boolean isRegularExpression() {
        return this instanceof BsonRegularExpression;
    }

    public boolean isJavaScript() {
        return this instanceof BsonJavaScript;
    }

    public boolean isJavaScriptWithScope() {
        return this instanceof BsonJavaScriptWithScope;
    }

    private void throwIfInvalidType(BsonType expectedType) {
        if (this.getBsonType() != expectedType) {
            throw new BsonInvalidOperationException(String.format("Value expected to be of type %s is of unexpected type %s", new Object[]{expectedType, this.getBsonType()}));
        }
    }
}

