/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson.codecs;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBinary;
import com.dre.brewery.depend.bson.BsonBoolean;
import com.dre.brewery.depend.bson.BsonDateTime;
import com.dre.brewery.depend.bson.BsonDbPointer;
import com.dre.brewery.depend.bson.BsonDecimal128;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonDocumentWrapper;
import com.dre.brewery.depend.bson.BsonDouble;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonInt64;
import com.dre.brewery.depend.bson.BsonJavaScript;
import com.dre.brewery.depend.bson.BsonJavaScriptWithScope;
import com.dre.brewery.depend.bson.BsonMaxKey;
import com.dre.brewery.depend.bson.BsonMinKey;
import com.dre.brewery.depend.bson.BsonNull;
import com.dre.brewery.depend.bson.BsonObjectId;
import com.dre.brewery.depend.bson.BsonRegularExpression;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonSymbol;
import com.dre.brewery.depend.bson.BsonTimestamp;
import com.dre.brewery.depend.bson.BsonType;
import com.dre.brewery.depend.bson.BsonUndefined;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.RawBsonDocument;
import com.dre.brewery.depend.bson.codecs.BsonArrayCodec;
import com.dre.brewery.depend.bson.codecs.BsonBinaryCodec;
import com.dre.brewery.depend.bson.codecs.BsonBooleanCodec;
import com.dre.brewery.depend.bson.codecs.BsonDBPointerCodec;
import com.dre.brewery.depend.bson.codecs.BsonDateTimeCodec;
import com.dre.brewery.depend.bson.codecs.BsonDecimal128Codec;
import com.dre.brewery.depend.bson.codecs.BsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.BsonDocumentWrapperCodec;
import com.dre.brewery.depend.bson.codecs.BsonDoubleCodec;
import com.dre.brewery.depend.bson.codecs.BsonInt32Codec;
import com.dre.brewery.depend.bson.codecs.BsonInt64Codec;
import com.dre.brewery.depend.bson.codecs.BsonJavaScriptCodec;
import com.dre.brewery.depend.bson.codecs.BsonJavaScriptWithScopeCodec;
import com.dre.brewery.depend.bson.codecs.BsonMaxKeyCodec;
import com.dre.brewery.depend.bson.codecs.BsonMinKeyCodec;
import com.dre.brewery.depend.bson.codecs.BsonNullCodec;
import com.dre.brewery.depend.bson.codecs.BsonObjectIdCodec;
import com.dre.brewery.depend.bson.codecs.BsonRegularExpressionCodec;
import com.dre.brewery.depend.bson.codecs.BsonStringCodec;
import com.dre.brewery.depend.bson.codecs.BsonSymbolCodec;
import com.dre.brewery.depend.bson.codecs.BsonTimestampCodec;
import com.dre.brewery.depend.bson.codecs.BsonTypeClassMap;
import com.dre.brewery.depend.bson.codecs.BsonUndefinedCodec;
import com.dre.brewery.depend.bson.codecs.BsonValueCodec;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.RawBsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.configuration.CodecProvider;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import java.util.HashMap;
import java.util.Map;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        if (BsonArray.class.isAssignableFrom(clazz)) {
            return new BsonArrayCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public String toString() {
        return "BsonValueCodecProvider{}";
    }

    static {
        HashMap map = new HashMap();
        map.put(BsonType.NULL, BsonNull.class);
        map.put(BsonType.ARRAY, BsonArray.class);
        map.put(BsonType.BINARY, BsonBinary.class);
        map.put(BsonType.BOOLEAN, BsonBoolean.class);
        map.put(BsonType.DATE_TIME, BsonDateTime.class);
        map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map.put(BsonType.DOCUMENT, BsonDocument.class);
        map.put(BsonType.DOUBLE, BsonDouble.class);
        map.put(BsonType.INT32, BsonInt32.class);
        map.put(BsonType.INT64, BsonInt64.class);
        map.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map.put(BsonType.MIN_KEY, BsonMinKey.class);
        map.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map.put(BsonType.STRING, BsonString.class);
        map.put(BsonType.SYMBOL, BsonSymbol.class);
        map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map);
    }
}

