/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson.codecs;

import com.dre.brewery.depend.bson.BsonBinarySubType;
import com.dre.brewery.depend.bson.BsonReader;
import com.dre.brewery.depend.bson.BsonType;
import com.dre.brewery.depend.bson.Transformer;
import com.dre.brewery.depend.bson.UuidRepresentation;
import com.dre.brewery.depend.bson.Vector;
import com.dre.brewery.depend.bson.codecs.BsonTypeCodecMap;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.codecs.configuration.CodecConfigurationException;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.bson.internal.UuidHelper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.UUID;

final class ContainerCodecHelper {
    static Object readValue(BsonReader reader, DecoderContext decoderContext, BsonTypeCodecMap bsonTypeCodecMap, UuidRepresentation uuidRepresentation, CodecRegistry registry, Transformer valueTransformer) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        Codec<?> currentCodec = bsonTypeCodecMap.get(bsonType);
        if (bsonType == BsonType.BINARY) {
            byte binarySubType = reader.peekBinarySubType();
            currentCodec = ContainerCodecHelper.getBinarySubTypeCodec(reader, uuidRepresentation, registry, binarySubType, currentCodec);
        }
        return valueTransformer.transform(currentCodec.decode(reader, decoderContext));
    }

    private static Codec<?> getBinarySubTypeCodec(BsonReader reader, UuidRepresentation uuidRepresentation, CodecRegistry registry, byte binarySubType, Codec<?> binaryTypeCodec) {
        if (binarySubType == BsonBinarySubType.VECTOR.getValue()) {
            Codec<Vector> vectorCodec = registry.get(Vector.class, registry);
            if (vectorCodec != null) {
                return vectorCodec;
            }
        } else if (reader.peekBinarySize() == 16) {
            switch (binarySubType) {
                case 3: {
                    if (!UuidHelper.isLegacyUUID(uuidRepresentation)) break;
                    return registry.get(UUID.class);
                }
                case 4: {
                    if (uuidRepresentation != UuidRepresentation.STANDARD) break;
                    return registry.get(UUID.class);
                }
            }
        }
        return binaryTypeCodec;
    }

    static Codec<?> getCodec(CodecRegistry codecRegistry, Type type) {
        if (type instanceof Class) {
            return codecRegistry.get((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return codecRegistry.get((Class)parameterizedType.getRawType(), Arrays.asList(parameterizedType.getActualTypeArguments()));
        }
        throw new CodecConfigurationException("Unsupported generic type of container: " + type);
    }

    private ContainerCodecHelper() {
    }
}

