/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson.internal;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBinary;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonJavaScriptWithScope;
import com.dre.brewery.depend.bson.BsonValue;

public final class BsonUtil {
    public static BsonDocument mutableDeepCopy(BsonDocument original) {
        BsonDocument copy = new BsonDocument(original.size());
        original.forEach((key, value) -> copy.put((String)key, BsonUtil.mutableDeepCopy(value)));
        return copy;
    }

    private static BsonArray mutableDeepCopy(BsonArray original) {
        BsonArray copy = new BsonArray(original.size());
        original.forEach(element -> copy.add(BsonUtil.mutableDeepCopy(element)));
        return copy;
    }

    private static BsonBinary mutableDeepCopy(BsonBinary original) {
        return new BsonBinary(original.getType(), (byte[])original.getData().clone());
    }

    private static BsonJavaScriptWithScope mutableDeepCopy(BsonJavaScriptWithScope original) {
        return new BsonJavaScriptWithScope(original.getCode(), BsonUtil.mutableDeepCopy(original.getScope()));
    }

    private static BsonValue mutableDeepCopy(BsonValue original) {
        switch (original.getBsonType()) {
            case DOCUMENT: {
                return BsonUtil.mutableDeepCopy(original.asDocument());
            }
            case ARRAY: {
                return BsonUtil.mutableDeepCopy(original.asArray());
            }
            case BINARY: {
                return BsonUtil.mutableDeepCopy(original.asBinary());
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return BsonUtil.mutableDeepCopy(original.asJavaScriptWithScope());
            }
        }
        return original;
    }

    private BsonUtil() {
    }
}

