/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson.internal;

import com.dre.brewery.depend.bson.BsonInvalidOperationException;
import com.dre.brewery.depend.bson.BsonReader;
import com.dre.brewery.depend.bson.BsonType;
import com.dre.brewery.depend.bson.types.Decimal128;
import java.math.BigDecimal;

public final class NumberCodecHelper {
    public static byte decodeByte(BsonReader reader) {
        int value = NumberCodecHelper.decodeInt(reader);
        if (value < -128 || value > 127) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Byte.", value));
        }
        return (byte)value;
    }

    public static short decodeShort(BsonReader reader) {
        int value = NumberCodecHelper.decodeInt(reader);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Short.", value));
        }
        return (short)value;
    }

    public static int decodeInt(BsonReader reader) {
        int intValue;
        BsonType bsonType = reader.getCurrentBsonType();
        switch (bsonType) {
            case INT32: {
                intValue = reader.readInt32();
                break;
            }
            case INT64: {
                long longValue = reader.readInt64();
                intValue = (int)longValue;
                if (longValue == (long)intValue) break;
                throw NumberCodecHelper.invalidConversion(Integer.class, longValue);
            }
            case DOUBLE: {
                double doubleValue = reader.readDouble();
                intValue = (int)doubleValue;
                if (doubleValue == (double)intValue) break;
                throw NumberCodecHelper.invalidConversion(Integer.class, doubleValue);
            }
            case DECIMAL128: {
                Decimal128 decimal128 = reader.readDecimal128();
                intValue = decimal128.intValue();
                if (decimal128.equals(new Decimal128(intValue))) break;
                throw NumberCodecHelper.invalidConversion(Integer.class, decimal128);
            }
            default: {
                throw new BsonInvalidOperationException(String.format("Invalid numeric type, found: %s", new Object[]{bsonType}));
            }
        }
        return intValue;
    }

    public static long decodeLong(BsonReader reader) {
        long longValue;
        BsonType bsonType = reader.getCurrentBsonType();
        switch (bsonType) {
            case INT32: {
                longValue = reader.readInt32();
                break;
            }
            case INT64: {
                longValue = reader.readInt64();
                break;
            }
            case DOUBLE: {
                double doubleValue = reader.readDouble();
                longValue = (long)doubleValue;
                if (doubleValue == (double)longValue) break;
                throw NumberCodecHelper.invalidConversion(Long.class, doubleValue);
            }
            case DECIMAL128: {
                Decimal128 decimal128 = reader.readDecimal128();
                longValue = decimal128.longValue();
                if (decimal128.equals(new Decimal128(longValue))) break;
                throw NumberCodecHelper.invalidConversion(Long.class, decimal128);
            }
            default: {
                throw new BsonInvalidOperationException(String.format("Invalid numeric type, found: %s", new Object[]{bsonType}));
            }
        }
        return longValue;
    }

    public static float decodeFloat(BsonReader reader) {
        double value = NumberCodecHelper.decodeDouble(reader);
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Float.", value));
        }
        return (float)value;
    }

    public static double decodeDouble(BsonReader reader) {
        double doubleValue;
        BsonType bsonType = reader.getCurrentBsonType();
        switch (bsonType) {
            case INT32: {
                doubleValue = reader.readInt32();
                break;
            }
            case INT64: {
                long longValue = reader.readInt64();
                doubleValue = longValue;
                if (longValue == (long)doubleValue) break;
                throw NumberCodecHelper.invalidConversion(Double.class, longValue);
            }
            case DOUBLE: {
                doubleValue = reader.readDouble();
                break;
            }
            case DECIMAL128: {
                Decimal128 decimal128 = reader.readDecimal128();
                try {
                    doubleValue = decimal128.doubleValue();
                    if (!decimal128.equals(new Decimal128(new BigDecimal(doubleValue)))) {
                        throw NumberCodecHelper.invalidConversion(Double.class, decimal128);
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    throw NumberCodecHelper.invalidConversion(Double.class, decimal128);
                }
            }
            default: {
                throw new BsonInvalidOperationException(String.format("Invalid numeric type, found: %s", new Object[]{bsonType}));
            }
        }
        return doubleValue;
    }

    private static <T extends Number> BsonInvalidOperationException invalidConversion(Class<T> clazz, Number value) {
        return new BsonInvalidOperationException(String.format("Could not convert `%s` to a %s without losing precision", value, clazz));
    }

    private NumberCodecHelper() {
    }
}

