/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb;

import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.configuration.CodecProvider;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistries;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.bson.codecs.kotlin.ArrayCodecProvider;
import com.dre.brewery.depend.bson.codecs.kotlin.DataClassCodecProvider;
import com.dre.brewery.depend.bson.codecs.kotlinx.KotlinSerializerCodecProvider;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class KotlinCodecProvider
implements CodecProvider {
    @Nullable
    private static final CodecProvider KOTLIN_SERIALIZABLE_CODEC_PROVIDER;
    @Nullable
    private static final CodecProvider DATA_CLASS_CODEC_PROVIDER;

    @Override
    @Nullable
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.get(clazz, Collections.emptyList(), registry);
    }

    @Override
    @Nullable
    public <T> Codec<T> get(Class<T> clazz, List<Type> typeArguments, CodecRegistry registry) {
        Codec<T> codec = null;
        if (KOTLIN_SERIALIZABLE_CODEC_PROVIDER != null) {
            codec = KOTLIN_SERIALIZABLE_CODEC_PROVIDER.get(clazz, typeArguments, registry);
        }
        if (codec == null && DATA_CLASS_CODEC_PROVIDER != null) {
            codec = DATA_CLASS_CODEC_PROVIDER.get(clazz, typeArguments, registry);
        }
        return codec;
    }

    static {
        Object possibleCodecProvider = null;
        try {
            Class.forName("com.dre.brewery.depend.bson.codecs.kotlinx.KotlinSerializerCodecProvider");
            possibleCodecProvider = new KotlinSerializerCodecProvider();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        KOTLIN_SERIALIZABLE_CODEC_PROVIDER = possibleCodecProvider;
        possibleCodecProvider = null;
        try {
            Class.forName("com.dre.brewery.depend.bson.codecs.kotlin.DataClassCodecProvider");
            possibleCodecProvider = CodecRegistries.fromProviders(new CodecProvider[]{new ArrayCodecProvider(), new DataClassCodecProvider()});
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DATA_CLASS_CODEC_PROVIDER = possibleCodecProvider;
    }
}

