/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.event;

import com.dre.brewery.depend.mongodb.RequestContext;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.event.CommandEvent;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class CommandFailedEvent
extends CommandEvent {
    private final long elapsedTimeNanos;
    private final Throwable throwable;

    public CommandFailedEvent(@Nullable RequestContext requestContext, long operationId, int requestId, ConnectionDescription connectionDescription, String databaseName, String commandName, long elapsedTimeNanos, Throwable throwable) {
        super(requestContext, operationId, requestId, connectionDescription, databaseName, commandName);
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
        this.throwable = throwable;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

