/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.event;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.mongodb.RequestContext;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.event.CommandEvent;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class CommandSucceededEvent
extends CommandEvent {
    private final BsonDocument response;
    private final long elapsedTimeNanos;

    public CommandSucceededEvent(@Nullable RequestContext requestContext, long operationId, int requestId, ConnectionDescription connectionDescription, String databaseName, String commandName, BsonDocument response, long elapsedTimeNanos) {
        super(requestContext, operationId, requestId, connectionDescription, databaseName, commandName);
        this.response = response;
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public BsonDocument getResponse() {
        return this.response;
    }
}

