/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.types.ObjectId;
import com.dre.brewery.depend.mongodb.MongoException;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ClusterDescription;
import com.dre.brewery.depend.mongodb.connection.ClusterId;
import com.dre.brewery.depend.mongodb.connection.ClusterSettings;
import com.dre.brewery.depend.mongodb.connection.ClusterType;
import com.dre.brewery.depend.mongodb.connection.ServerConnectionState;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.connection.ServerType;
import com.dre.brewery.depend.mongodb.event.ServerDescriptionChangedEvent;
import com.dre.brewery.depend.mongodb.internal.TimeoutContext;
import com.dre.brewery.depend.mongodb.internal.connection.BaseCluster;
import com.dre.brewery.depend.mongodb.internal.connection.Cluster;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterableServer;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterableServerFactory;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Logger;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Loggers;
import com.dre.brewery.depend.mongodb.internal.time.Timeout;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractMultiServerCluster
extends BaseCluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private ClusterType clusterType;
    private String replicaSetName;
    private ObjectId maxElectionId;
    private Integer maxSetVersion;
    private final ConcurrentMap<ServerAddress, ServerTuple> addressToServerTupleMap = new ConcurrentHashMap<ServerAddress, ServerTuple>();

    AbstractMultiServerCluster(ClusterId clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory) {
        super(clusterId, settings, serverFactory);
        Assertions.isTrue("connection mode is multiple", settings.getMode() == ClusterConnectionMode.MULTIPLE);
        this.clusterType = settings.getRequiredClusterType();
        this.replicaSetName = settings.getRequiredReplicaSetName();
    }

    ClusterType getClusterType() {
        return this.clusterType;
    }

    @Nullable
    MongoException getSrvResolutionException() {
        return null;
    }

    protected void initialize(Collection<ServerAddress> serverAddresses) {
        ClusterDescription currentDescription = this.getCurrentDescription();
        this.withLock(() -> {
            for (ServerAddress serverAddress : serverAddresses) {
                this.addServer(serverAddress);
            }
            ClusterDescription newDescription = this.updateDescription();
            this.fireChangeEvent(newDescription, currentDescription);
        });
    }

    @Override
    protected void connect() {
        for (ServerTuple cur : this.addressToServerTupleMap.values()) {
            cur.server.connect();
        }
    }

    @Override
    public void close() {
        this.withLock(() -> {
            if (!this.isClosed()) {
                for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
                    serverTuple.server.close();
                }
            }
            super.close();
        });
    }

    @Override
    public Cluster.ServersSnapshot getServersSnapshot(Timeout serverSelectionTimeout, TimeoutContext timeoutContext) {
        Assertions.isTrue("is open", !this.isClosed());
        HashMap<ServerAddress, ServerTuple> nonAtomicSnapshot = new HashMap<ServerAddress, ServerTuple>(this.addressToServerTupleMap);
        return serverAddress -> {
            ServerTuple serverTuple = (ServerTuple)nonAtomicSnapshot.get(serverAddress);
            return serverTuple == null ? null : serverTuple.server;
        };
    }

    void onChange(Collection<ServerAddress> newHosts) {
        this.withLock(() -> {
            if (this.isClosed()) {
                return;
            }
            for (Object cur : newHosts) {
                this.addServer((ServerAddress)cur);
            }
            Iterator iterator = this.addressToServerTupleMap.values().iterator();
            while (iterator.hasNext()) {
                Object cur;
                cur = (ServerTuple)iterator.next();
                if (newHosts.contains(((ServerTuple)cur).description.getAddress())) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("Removing %s from client view of cluster.", ((ServerTuple)cur).description.getAddress()));
                }
                iterator.remove();
                ((ServerTuple)cur).server.close();
            }
            ClusterDescription oldClusterDescription = this.getCurrentDescription();
            ClusterDescription newClusterDescription = this.updateDescription();
            this.fireChangeEvent(newClusterDescription, oldClusterDescription);
        });
    }

    @Override
    public void onChange(ServerDescriptionChangedEvent event) {
        this.withLock(() -> {
            ServerTuple serverTuple;
            if (this.isClosed()) {
                return;
            }
            ServerDescription newDescription = event.getNewDescription();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Handling description changed event for server %s with description %s", newDescription.getAddress(), newDescription));
            }
            if ((serverTuple = (ServerTuple)this.addressToServerTupleMap.get(newDescription.getAddress())) == null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("Ignoring description changed event for removed server %s", newDescription.getAddress()));
                }
                return;
            }
            boolean shouldUpdateDescription = true;
            if (newDescription.isOk()) {
                if (this.clusterType == ClusterType.UNKNOWN && newDescription.getType() != ServerType.REPLICA_SET_GHOST) {
                    this.clusterType = newDescription.getClusterType();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(String.format("Discovered cluster type of %s", new Object[]{this.clusterType}));
                    }
                }
                switch (this.clusterType) {
                    case REPLICA_SET: {
                        shouldUpdateDescription = this.handleReplicaSetMemberChanged(newDescription);
                        break;
                    }
                    case SHARDED: {
                        shouldUpdateDescription = this.handleShardRouterChanged(newDescription);
                        break;
                    }
                    case STANDALONE: {
                        shouldUpdateDescription = this.handleStandAloneChanged(newDescription);
                        break;
                    }
                }
            }
            ClusterDescription oldClusterDescription = null;
            ClusterDescription newClusterDescription = null;
            if (shouldUpdateDescription) {
                serverTuple.description = newDescription;
                oldClusterDescription = this.getCurrentDescription();
                newClusterDescription = this.updateDescription();
            }
            if (shouldUpdateDescription) {
                this.fireChangeEvent(newClusterDescription, oldClusterDescription);
            }
        });
    }

    private boolean handleReplicaSetMemberChanged(ServerDescription newDescription) {
        if (!newDescription.isReplicaSetMember()) {
            LOGGER.error(String.format("Expecting replica set member, but found a %s.  Removing %s from client view of cluster.", new Object[]{newDescription.getType(), newDescription.getAddress()}));
            this.removeServer(newDescription.getAddress());
            return true;
        }
        if (newDescription.getType() == ServerType.REPLICA_SET_GHOST) {
            LOGGER.info(String.format("Server %s does not appear to be a member of an initiated replica set.", newDescription.getAddress()));
            return true;
        }
        if (this.replicaSetName == null) {
            this.replicaSetName = Assertions.assertNotNull(newDescription.getSetName());
        }
        if (!this.replicaSetName.equals(newDescription.getSetName())) {
            LOGGER.error(String.format("Expecting replica set member from set '%s', but found one from set '%s'.  Removing %s from client view of cluster.", this.replicaSetName, newDescription.getSetName(), newDescription.getAddress()));
            this.removeServer(newDescription.getAddress());
            return true;
        }
        this.ensureServers(newDescription);
        if (newDescription.getCanonicalAddress() != null && !newDescription.getAddress().equals(new ServerAddress(newDescription.getCanonicalAddress())) && !newDescription.isPrimary()) {
            LOGGER.info(String.format("Canonical address %s does not match server address.  Removing %s from client view of cluster", newDescription.getCanonicalAddress(), newDescription.getAddress()));
            this.removeServer(newDescription.getAddress());
            return true;
        }
        if (!newDescription.isPrimary()) {
            return true;
        }
        if (this.isStalePrimary(newDescription)) {
            this.invalidatePotentialPrimary(newDescription);
            return false;
        }
        this.maxElectionId = AbstractMultiServerCluster.nullSafeMax(newDescription.getElectionId(), this.maxElectionId);
        this.maxSetVersion = AbstractMultiServerCluster.nullSafeMax(newDescription.getSetVersion(), this.maxSetVersion);
        this.invalidateOldPrimaries(newDescription.getAddress());
        if (this.isNotAlreadyPrimary(newDescription.getAddress())) {
            LOGGER.info(String.format("Discovered replica set primary %s with max election id %s and max set version %d", newDescription.getAddress(), newDescription.getElectionId(), newDescription.getSetVersion()));
        }
        return true;
    }

    private boolean isStalePrimary(ServerDescription description) {
        ObjectId electionId = description.getElectionId();
        Integer setVersion = description.getSetVersion();
        if (description.getMaxWireVersion() >= 17) {
            return AbstractMultiServerCluster.nullSafeCompareTo(electionId, this.maxElectionId) < 0 || AbstractMultiServerCluster.nullSafeCompareTo(electionId, this.maxElectionId) == 0 && AbstractMultiServerCluster.nullSafeCompareTo(setVersion, this.maxSetVersion) < 0;
        }
        return setVersion != null && electionId != null && (AbstractMultiServerCluster.nullSafeCompareTo(setVersion, this.maxSetVersion) < 0 || AbstractMultiServerCluster.nullSafeCompareTo(setVersion, this.maxSetVersion) == 0 && AbstractMultiServerCluster.nullSafeCompareTo(electionId, this.maxElectionId) < 0);
    }

    private void invalidatePotentialPrimary(ServerDescription newDescription) {
        LOGGER.info(String.format("Invalidating potential primary %s whose (set version, election id) tuple of (%d, %s) is less than one already seen of (%d, %s)", newDescription.getAddress(), newDescription.getSetVersion(), newDescription.getElectionId(), this.maxSetVersion, this.maxElectionId));
        ((ServerTuple)this.addressToServerTupleMap.get(newDescription.getAddress())).server.resetToConnecting();
    }

    private static <T extends Comparable<T>> int nullSafeCompareTo(@Nullable T first, @Nullable T second) {
        if (first == null) {
            return second == null ? 0 : -1;
        }
        if (second == null) {
            return 1;
        }
        return first.compareTo(second);
    }

    @Nullable
    private static <T extends Comparable<T>> T nullSafeMax(@Nullable T first, @Nullable T second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first.compareTo(second) >= 0 ? first : second;
    }

    private boolean isNotAlreadyPrimary(ServerAddress address) {
        ServerTuple serverTuple = (ServerTuple)this.addressToServerTupleMap.get(address);
        return serverTuple == null || !serverTuple.description.isPrimary();
    }

    private boolean handleShardRouterChanged(ServerDescription newDescription) {
        if (!newDescription.isShardRouter()) {
            LOGGER.error(String.format("Expecting a %s, but found a %s.  Removing %s from client view of cluster.", new Object[]{ServerType.SHARD_ROUTER, newDescription.getType(), newDescription.getAddress()}));
            this.removeServer(newDescription.getAddress());
        }
        return true;
    }

    private boolean handleStandAloneChanged(ServerDescription newDescription) {
        if (this.getSettings().getHosts().size() > 1) {
            LOGGER.error(String.format("Expecting a single %s, but found more than one.  Removing %s from client view of cluster.", new Object[]{ServerType.STANDALONE, newDescription.getAddress()}));
            this.clusterType = ClusterType.UNKNOWN;
            this.removeServer(newDescription.getAddress());
        }
        return true;
    }

    private void addServer(ServerAddress serverAddress) {
        if (!this.addressToServerTupleMap.containsKey(serverAddress)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Adding discovered server %s to client view of cluster", serverAddress));
            }
            ClusterableServer server = this.createServer(serverAddress);
            this.addressToServerTupleMap.put(serverAddress, new ServerTuple(server, this.getConnectingServerDescription(serverAddress)));
        }
    }

    private void removeServer(ServerAddress serverAddress) {
        ServerTuple removed = (ServerTuple)this.addressToServerTupleMap.remove(serverAddress);
        if (removed != null) {
            removed.server.close();
        }
    }

    private void invalidateOldPrimaries(ServerAddress newPrimary) {
        for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
            if (serverTuple.description.getAddress().equals(newPrimary) || !serverTuple.description.isPrimary()) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Rediscovering type of existing primary %s", serverTuple.description.getAddress()));
            }
            serverTuple.server.invalidate();
        }
    }

    private ServerDescription getConnectingServerDescription(ServerAddress serverAddress) {
        return ServerDescription.builder().state(ServerConnectionState.CONNECTING).address(serverAddress).build();
    }

    private ClusterDescription updateDescription() {
        ClusterDescription newDescription = new ClusterDescription(ClusterConnectionMode.MULTIPLE, this.clusterType, this.getSrvResolutionException(), this.getNewServerDescriptionList(), this.getSettings(), this.getServerFactory().getSettings());
        this.updateDescription(newDescription);
        return newDescription;
    }

    private List<ServerDescription> getNewServerDescriptionList() {
        ArrayList<ServerDescription> serverDescriptions = new ArrayList<ServerDescription>();
        for (ServerTuple cur : this.addressToServerTupleMap.values()) {
            serverDescriptions.add(cur.description);
        }
        return serverDescriptions;
    }

    private void ensureServers(ServerDescription description) {
        if (description.isPrimary() || !this.hasPrimary()) {
            this.addNewHosts(description.getHosts());
            this.addNewHosts(description.getPassives());
            this.addNewHosts(description.getArbiters());
        }
        if (description.isPrimary()) {
            this.removeExtraHosts(description);
        }
    }

    private boolean hasPrimary() {
        for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
            if (!serverTuple.description.isPrimary()) continue;
            return true;
        }
        return false;
    }

    private void addNewHosts(Set<String> hosts) {
        for (String cur : hosts) {
            this.addServer(new ServerAddress(cur));
        }
    }

    private void removeExtraHosts(ServerDescription serverDescription) {
        Set<ServerAddress> allServerAddresses = this.getAllServerAddresses(serverDescription);
        Iterator iterator = this.addressToServerTupleMap.values().iterator();
        while (iterator.hasNext()) {
            ServerTuple cur = (ServerTuple)iterator.next();
            if (allServerAddresses.contains(cur.description.getAddress())) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Server %s is no longer a member of the replica set.  Removing from client view of cluster.", cur.description.getAddress()));
            }
            iterator.remove();
            cur.server.close();
        }
    }

    private Set<ServerAddress> getAllServerAddresses(ServerDescription serverDescription) {
        HashSet<ServerAddress> retVal = new HashSet<ServerAddress>();
        this.addHostsToSet(serverDescription.getHosts(), retVal);
        this.addHostsToSet(serverDescription.getPassives(), retVal);
        this.addHostsToSet(serverDescription.getArbiters(), retVal);
        return retVal;
    }

    private void addHostsToSet(Set<String> hosts, Set<ServerAddress> retVal) {
        for (String host : hosts) {
            retVal.add(new ServerAddress(host));
        }
    }

    private static final class ServerTuple {
        private final ClusterableServer server;
        private ServerDescription description;

        private ServerTuple(ClusterableServer server, ServerDescription description) {
            this.server = server;
            this.description = description;
        }
    }
}

