/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonTimestamp;
import com.dre.brewery.depend.mongodb.internal.Locks;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ClusterClock {
    private static final String CLUSTER_TIME_KEY = "clusterTime";
    private final ReentrantLock lock = new ReentrantLock();
    private BsonDocument clusterTime;

    public BsonDocument getCurrent() {
        return Locks.withInterruptibleLock((Lock)this.lock, () -> this.clusterTime);
    }

    public BsonTimestamp getClusterTime() {
        return Locks.withInterruptibleLock((Lock)this.lock, () -> this.clusterTime != null ? this.clusterTime.getTimestamp(CLUSTER_TIME_KEY) : null);
    }

    public void advance(@Nullable BsonDocument other) {
        Locks.withInterruptibleLock((Lock)this.lock, () -> {
            this.clusterTime = this.greaterOf(other);
            return this.clusterTime;
        });
    }

    public BsonDocument greaterOf(@Nullable BsonDocument other) {
        return Locks.withInterruptibleLock((Lock)this.lock, () -> {
            if (other == null) {
                return this.clusterTime;
            }
            if (this.clusterTime == null) {
                return other;
            }
            return other.getTimestamp(CLUSTER_TIME_KEY).compareTo(this.clusterTime.getTimestamp(CLUSTER_TIME_KEY)) > 0 ? other : this.clusterTime;
        });
    }
}

