/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.annotations.Immutable;
import com.dre.brewery.depend.mongodb.annotations.NotThreadSafe;
import com.dre.brewery.depend.mongodb.connection.ServerType;

@Immutable
public final class MessageSettings {
    private static final int DEFAULT_MAX_DOCUMENT_SIZE = 0x1000000;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x2000000;
    private static final int DEFAULT_MAX_BATCH_COUNT = 1000;
    private final int maxDocumentSize;
    private final int maxMessageSize;
    private final int maxBatchCount;
    private final int maxWireVersion;
    private final ServerType serverType;
    private final boolean sessionSupported;
    private final boolean cryptd;

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxDocumentSize() {
        return this.maxDocumentSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public boolean isCryptd() {
        return this.cryptd;
    }

    public boolean isSessionSupported() {
        return this.sessionSupported;
    }

    private MessageSettings(Builder builder) {
        this.maxDocumentSize = builder.maxDocumentSize;
        this.maxMessageSize = builder.maxMessageSize;
        this.maxBatchCount = builder.maxBatchCount;
        this.maxWireVersion = builder.maxWireVersion;
        this.serverType = builder.serverType;
        this.sessionSupported = builder.sessionSupported;
        this.cryptd = builder.cryptd;
    }

    @NotThreadSafe
    public static final class Builder {
        private int maxDocumentSize = 0x1000000;
        private int maxMessageSize = 0x2000000;
        private int maxBatchCount = 1000;
        private int maxWireVersion;
        private ServerType serverType;
        private boolean sessionSupported;
        private boolean cryptd;

        public MessageSettings build() {
            return new MessageSettings(this);
        }

        public Builder maxDocumentSize(int maxDocumentSize) {
            this.maxDocumentSize = maxDocumentSize;
            return this;
        }

        public Builder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }

        public Builder maxBatchCount(int maxBatchCount) {
            this.maxBatchCount = maxBatchCount;
            return this;
        }

        public Builder maxWireVersion(int maxWireVersion) {
            this.maxWireVersion = maxWireVersion;
            return this;
        }

        public Builder serverType(ServerType serverType) {
            this.serverType = serverType;
            return this;
        }

        public Builder sessionSupported(boolean sessionSupported) {
            this.sessionSupported = sessionSupported;
            return this;
        }

        public Builder cryptd(boolean cryptd) {
            this.cryptd = cryptd;
            return this;
        }
    }
}

