/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.AuthenticationMechanism;
import com.dre.brewery.depend.mongodb.MongoCredential;
import com.dre.brewery.depend.mongodb.internal.Locks;
import com.dre.brewery.depend.mongodb.internal.connection.OidcAuthenticator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;

public class MongoCredentialWithCache {
    private final MongoCredential credential;
    private final Cache cache;

    public MongoCredentialWithCache(MongoCredential credential) {
        this(credential, new Cache());
    }

    private MongoCredentialWithCache(MongoCredential credential, Cache cache) {
        this.credential = credential;
        this.cache = cache;
    }

    public MongoCredentialWithCache withMechanism(AuthenticationMechanism mechanism) {
        return new MongoCredentialWithCache(this.credential.withMechanism(mechanism), this.cache);
    }

    @Nullable
    public AuthenticationMechanism getAuthenticationMechanism() {
        return this.credential.getAuthenticationMechanism();
    }

    public MongoCredential getCredential() {
        return this.credential;
    }

    @Nullable
    public <T> T getFromCache(Object key, Class<T> clazz) {
        return clazz.cast(this.cache.get(key));
    }

    public void putInCache(Object key, Object value) {
        this.cache.set(key, value);
    }

    OidcAuthenticator.OidcCacheEntry getOidcCacheEntry() {
        return this.cache.oidcCacheEntry;
    }

    void setOidcCacheEntry(OidcAuthenticator.OidcCacheEntry oidcCacheEntry) {
        this.cache.oidcCacheEntry = oidcCacheEntry;
    }

    StampedLock getOidcLock() {
        return this.cache.oidcLock;
    }

    public Lock getLock() {
        return this.cache.lock;
    }

    static class Cache {
        private final ReentrantLock lock = new ReentrantLock();
        private Object cacheKey;
        private Object cacheValue;
        private final StampedLock oidcLock = new StampedLock();
        private volatile OidcAuthenticator.OidcCacheEntry oidcCacheEntry = new OidcAuthenticator.OidcCacheEntry();

        Cache() {
        }

        Object get(Object key) {
            return Locks.withInterruptibleLock((Lock)this.lock, () -> {
                if (this.cacheKey != null && this.cacheKey.equals(key)) {
                    return this.cacheValue;
                }
                return null;
            });
        }

        void set(Object key, Object value) {
            Locks.withInterruptibleLock((Lock)this.lock, () -> {
                this.cacheKey = key;
                this.cacheValue = value;
            });
        }
    }
}

