/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.ReadConcernLevel;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.internal.session.SessionContext;

public final class ReadConcernHelper {
    public static BsonDocument getReadConcernDocument(SessionContext sessionContext, int maxWireVersion) {
        Assertions.notNull("sessionContext", sessionContext);
        BsonDocument readConcernDocument = new BsonDocument();
        ReadConcernLevel level = sessionContext.getReadConcern().getLevel();
        if (level != null) {
            readConcernDocument.append("level", new BsonString(level.getValue()));
        }
        Assertions.assertFalse(sessionContext.isSnapshot() && sessionContext.isCausallyConsistent());
        if (sessionContext.isSnapshot() && maxWireVersion < 12) {
            throw new MongoClientException("Snapshot reads require MongoDB 5.0 or later");
        }
        if (ReadConcernHelper.shouldAddAfterClusterTime(sessionContext)) {
            readConcernDocument.append("afterClusterTime", sessionContext.getOperationTime());
        } else if (ReadConcernHelper.shouldAddAtClusterTime(sessionContext)) {
            readConcernDocument.append("atClusterTime", sessionContext.getSnapshotTimestamp());
        }
        return readConcernDocument;
    }

    private static boolean shouldAddAtClusterTime(SessionContext sessionContext) {
        return sessionContext.isSnapshot() && sessionContext.getSnapshotTimestamp() != null;
    }

    private static boolean shouldAddAfterClusterTime(SessionContext sessionContext) {
        return sessionContext.isCausallyConsistent() && sessionContext.getOperationTime() != null;
    }

    private ReadConcernHelper() {
    }
}

