/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.BsonBinaryReader;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.io.ByteBufferBsonInput;
import com.dre.brewery.depend.mongodb.MongoInternalException;
import com.dre.brewery.depend.mongodb.internal.connection.ResponseBuffers;

public class ReplyMessage<T> {
    private final T document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyMessage(ResponseBuffers responseBuffers, Decoder<T> decoder, long requestId) {
        if (requestId != (long)responseBuffers.getReplyHeader().getResponseTo()) {
            throw new MongoInternalException(String.format("The responseTo (%d) in the response does not match the requestId (%d) in the request", responseBuffers.getReplyHeader().getResponseTo(), requestId));
        }
        try (ByteBufferBsonInput bsonInput = new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer().duplicate());
             BsonBinaryReader reader = new BsonBinaryReader(bsonInput);){
            this.document = decoder.decode(reader, DecoderContext.builder().build());
        }
        finally {
            responseBuffers.reset();
        }
    }

    public T getDocument() {
        return this.document;
    }
}

