/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.annotations.ThreadSafe;
import com.dre.brewery.depend.mongodb.internal.connection.ExponentiallyWeightedMovingAverage;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

final class RoundTripTimeSampler {
    private final ExponentiallyWeightedMovingAverage averageRoundTripTime = new ExponentiallyWeightedMovingAverage(0.2);
    private final RecentSamples recentSamples = new RecentSamples();

    RoundTripTimeSampler() {
    }

    void reset() {
        this.averageRoundTripTime.reset();
        this.recentSamples.reset();
    }

    void addSample(long sample) {
        this.recentSamples.add(sample);
        this.averageRoundTripTime.addSample(sample);
    }

    long getAverage() {
        return this.averageRoundTripTime.getAverage();
    }

    long getMin() {
        return this.recentSamples.min();
    }

    @ThreadSafe
    private static final class RecentSamples {
        private static final int MAX_SIZE = 10;
        private final Deque<Long> samples = new ConcurrentLinkedDeque<Long>();

        RecentSamples() {
        }

        void add(long sample) {
            if (this.samples.size() == 10) {
                this.samples.removeFirst();
            }
            this.samples.add(sample);
        }

        void reset() {
            this.samples.clear();
        }

        long min() {
            return this.samples.size() < 2 ? 0L : this.samples.stream().min(Long::compareTo).orElse(0L);
        }
    }
}

