/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.MongoClientSettings;
import com.dre.brewery.depend.mongodb.MongoSocketException;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.UnixServerAddress;
import com.dre.brewery.depend.mongodb.internal.connection.DefaultInetAddressResolver;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import com.dre.brewery.depend.mongodb.spi.dns.InetAddressResolver;
import com.dre.brewery.depend.mongodb.spi.dns.InetAddressResolverProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class ServerAddressHelper {
    @Nullable
    private static final InetAddressResolver LOCATED_INET_ADDRESS_RESOLVER = StreamSupport.stream(ServiceLoader.load(InetAddressResolverProvider.class).spliterator(), false).findFirst().map(InetAddressResolverProvider::create).orElse(null);

    public static ServerAddress createServerAddress(String host) {
        return ServerAddressHelper.createServerAddress(host, ServerAddress.defaultPort());
    }

    public static ServerAddress createServerAddress(String host, int port) {
        if (host != null && host.endsWith(".sock")) {
            return new UnixServerAddress(host);
        }
        return new ServerAddress(host, port);
    }

    public static InetAddressResolver getInetAddressResolver(MongoClientSettings settings) {
        InetAddressResolver explicitInetAddressResolver = settings.getInetAddressResolver();
        if (explicitInetAddressResolver != null) {
            return explicitInetAddressResolver;
        }
        if (LOCATED_INET_ADDRESS_RESOLVER != null) {
            return LOCATED_INET_ADDRESS_RESOLVER;
        }
        return new DefaultInetAddressResolver();
    }

    public static List<InetSocketAddress> getSocketAddresses(ServerAddress serverAddress, InetAddressResolver resolver) {
        try {
            return resolver.lookupByName(serverAddress.getHost()).stream().map(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, serverAddress.getPort())).collect(Collectors.toList());
        }
        catch (UnknownHostException e) {
            throw new MongoSocketException(e.getMessage(), serverAddress, (Throwable)e);
        }
    }

    private ServerAddressHelper() {
    }
}

