/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.ByteBuf;
import com.dre.brewery.depend.mongodb.MongoSocketException;
import com.dre.brewery.depend.mongodb.MongoSocketOpenException;
import com.dre.brewery.depend.mongodb.MongoSocketReadException;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.AsyncCompletionHandler;
import com.dre.brewery.depend.mongodb.connection.ProxySettings;
import com.dre.brewery.depend.mongodb.connection.SocketSettings;
import com.dre.brewery.depend.mongodb.connection.SslSettings;
import com.dre.brewery.depend.mongodb.internal.TimeoutContext;
import com.dre.brewery.depend.mongodb.internal.connection.BufferProvider;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.connection.ServerAddressHelper;
import com.dre.brewery.depend.mongodb.internal.connection.SocketStreamHelper;
import com.dre.brewery.depend.mongodb.internal.connection.SocksSocket;
import com.dre.brewery.depend.mongodb.internal.connection.SslHelper;
import com.dre.brewery.depend.mongodb.internal.connection.Stream;
import com.dre.brewery.depend.mongodb.internal.thread.InterruptionUtil;
import com.dre.brewery.depend.mongodb.spi.dns.InetAddressResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketStream
implements Stream {
    private final ServerAddress address;
    private final InetAddressResolver inetAddressResolver;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final SocketFactory socketFactory;
    private final BufferProvider bufferProvider;
    private volatile Socket socket;
    private volatile OutputStream outputStream;
    private volatile InputStream inputStream;
    private volatile boolean isClosed;

    public SocketStream(ServerAddress address, InetAddressResolver inetAddressResolver, SocketSettings settings, SslSettings sslSettings, SocketFactory socketFactory, BufferProvider bufferProvider) {
        this.address = Assertions.notNull("address", address);
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.socketFactory = Assertions.notNull("socketFactory", socketFactory);
        this.bufferProvider = Assertions.notNull("bufferProvider", bufferProvider);
        this.inetAddressResolver = inetAddressResolver;
    }

    @Override
    public void open(OperationContext operationContext) {
        try {
            this.socket = this.initializeSocket(operationContext);
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
        }
        catch (IOException e) {
            this.close();
            throw InterruptionUtil.translateInterruptedException(e, "Interrupted while connecting").orElseThrow(() -> new MongoSocketOpenException("Exception opening socket", this.getAddress(), (Throwable)e));
        }
    }

    protected Socket initializeSocket(OperationContext operationContext) throws IOException {
        ProxySettings proxySettings = this.settings.getProxySettings();
        if (proxySettings.isProxyEnabled()) {
            if (this.sslSettings.isEnabled()) {
                Assertions.assertTrue(this.socketFactory instanceof SSLSocketFactory);
                SSLSocketFactory sslSocketFactory = (SSLSocketFactory)this.socketFactory;
                return this.initializeSslSocketOverSocksProxy(operationContext, sslSocketFactory);
            }
            return this.initializeSocketOverSocksProxy(operationContext);
        }
        Iterator<InetSocketAddress> inetSocketAddresses = ServerAddressHelper.getSocketAddresses(this.address, this.inetAddressResolver).iterator();
        while (inetSocketAddresses.hasNext()) {
            Socket socket = this.socketFactory.createSocket();
            try {
                SocketStreamHelper.initialize(operationContext, socket, inetSocketAddresses.next(), this.settings, this.sslSettings);
                return socket;
            }
            catch (SocketTimeoutException e) {
                if (inetSocketAddresses.hasNext()) continue;
                throw e;
            }
        }
        throw new MongoSocketException("Exception opening socket", this.getAddress());
    }

    private SSLSocket initializeSslSocketOverSocksProxy(OperationContext operationContext, SSLSocketFactory sslSocketFactory) throws IOException {
        String serverHost = this.address.getHost();
        int serverPort = this.address.getPort();
        SocksSocket socksProxy = new SocksSocket(this.settings.getProxySettings());
        SocketStreamHelper.configureSocket(socksProxy, operationContext, this.settings);
        InetSocketAddress inetSocketAddress = SocketStream.toSocketAddress(serverHost, serverPort);
        socksProxy.connect(inetSocketAddress, operationContext.getTimeoutContext().getConnectTimeoutMs());
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socksProxy, serverHost, serverPort, true);
        SslHelper.configureSslSocket(sslSocket, this.sslSettings, inetSocketAddress);
        return sslSocket;
    }

    private static InetSocketAddress toSocketAddress(String serverHost, int serverPort) {
        return InetSocketAddress.createUnresolved(serverHost, serverPort);
    }

    private Socket initializeSocketOverSocksProxy(OperationContext operationContext) throws IOException {
        Socket createdSocket = this.socketFactory.createSocket();
        SocketStreamHelper.configureSocket(createdSocket, operationContext, this.settings);
        SocksSocket socksProxy = new SocksSocket(createdSocket, this.settings.getProxySettings());
        socksProxy.connect(SocketStream.toSocketAddress(this.address.getHost(), this.address.getPort()), operationContext.getTimeoutContext().getConnectTimeoutMs());
        return socksProxy;
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return this.bufferProvider.getBuffer(size);
    }

    @Override
    public void write(List<ByteBuf> buffers, OperationContext operationContext) throws IOException {
        for (ByteBuf cur : buffers) {
            this.outputStream.write(cur.array(), 0, cur.limit());
            operationContext.getTimeoutContext().onExpired(() -> TimeoutContext.throwMongoTimeoutException("Socket write exceeded the timeout limit."));
        }
    }

    @Override
    public ByteBuf read(int numBytes, OperationContext operationContext) throws IOException {
        try {
            ByteBuf buffer = this.bufferProvider.getBuffer(numBytes);
            try {
                int bytesRead;
                byte[] bytes = buffer.array();
                for (int totalBytesRead = 0; totalBytesRead < buffer.limit(); totalBytesRead += bytesRead) {
                    int readTimeoutMS = (int)operationContext.getTimeoutContext().getReadTimeoutMS();
                    this.socket.setSoTimeout(readTimeoutMS);
                    bytesRead = this.inputStream.read(bytes, totalBytesRead, buffer.limit() - totalBytesRead);
                    if (bytesRead != -1) continue;
                    throw new MongoSocketReadException("Prematurely reached end of stream", this.getAddress());
                }
                ByteBuf byteBuf = buffer;
                return byteBuf;
            }
            catch (Exception e) {
                buffer.release();
                throw e;
            }
        }
        finally {
            if (!this.socket.isClosed()) {
                this.socket.setSoTimeout(0);
            }
        }
    }

    @Override
    public void openAsync(OperationContext operationContext, AsyncCompletionHandler<Void> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void writeAsync(List<ByteBuf> buffers, OperationContext operationContext, AsyncCompletionHandler<Void> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public void readAsync(int numBytes, OperationContext operationContext, AsyncCompletionHandler<ByteBuf> handler) {
        throw new UnsupportedOperationException(this.getClass() + " does not support asynchronous operations.");
    }

    @Override
    public ServerAddress getAddress() {
        return this.address;
    }

    SocketSettings getSettings() {
        return this.settings;
    }

    @Override
    public void close() {
        try {
            this.isClosed = true;
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

