/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.event;

import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterSettings;
import com.dre.brewery.depend.mongodb.connection.ConnectionPoolSettings;
import com.dre.brewery.depend.mongodb.connection.ServerSettings;
import com.dre.brewery.depend.mongodb.event.ClusterListener;
import com.dre.brewery.depend.mongodb.event.CommandListener;
import com.dre.brewery.depend.mongodb.event.ConnectionPoolListener;
import com.dre.brewery.depend.mongodb.event.ServerListener;
import com.dre.brewery.depend.mongodb.event.ServerMonitorListener;
import com.dre.brewery.depend.mongodb.internal.event.ClusterListenerMulticaster;
import com.dre.brewery.depend.mongodb.internal.event.CommandListenerMulticaster;
import com.dre.brewery.depend.mongodb.internal.event.ConnectionPoolListenerMulticaster;
import com.dre.brewery.depend.mongodb.internal.event.ServerListenerMulticaster;
import com.dre.brewery.depend.mongodb.internal.event.ServerMonitorListenerMulticaster;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.List;

public final class EventListenerHelper {
    public static final ServerListener NO_OP_SERVER_LISTENER = new ServerListener(){};
    public static final ServerMonitorListener NO_OP_SERVER_MONITOR_LISTENER = new ServerMonitorListener(){};
    public static final ClusterListener NO_OP_CLUSTER_LISTENER = new ClusterListener(){};
    private static final ConnectionPoolListener NO_OP_CONNECTION_POOL_LISTENER = new ConnectionPoolListener(){};

    public static ClusterListener singleClusterListener(ClusterSettings clusterSettings) {
        Assertions.assertTrue(clusterSettings.getClusterListeners().size() <= 1);
        return clusterSettings.getClusterListeners().isEmpty() ? NO_OP_CLUSTER_LISTENER : clusterSettings.getClusterListeners().get(0);
    }

    public static ServerListener singleServerListener(ServerSettings serverSettings) {
        Assertions.assertTrue(serverSettings.getServerListeners().size() <= 1);
        return serverSettings.getServerListeners().isEmpty() ? NO_OP_SERVER_LISTENER : serverSettings.getServerListeners().get(0);
    }

    public static ServerMonitorListener singleServerMonitorListener(ServerSettings serverSettings) {
        Assertions.assertTrue(serverSettings.getServerMonitorListeners().size() <= 1);
        return serverSettings.getServerMonitorListeners().isEmpty() ? NO_OP_SERVER_MONITOR_LISTENER : serverSettings.getServerMonitorListeners().get(0);
    }

    public static ClusterListener clusterListenerMulticaster(List<ClusterListener> clusterListeners) {
        return new ClusterListenerMulticaster(clusterListeners);
    }

    public static ServerListener serverListenerMulticaster(List<ServerListener> serverListeners) {
        return new ServerListenerMulticaster(serverListeners);
    }

    public static ServerMonitorListener serverMonitorListenerMulticaster(List<ServerMonitorListener> serverMonitorListeners) {
        return new ServerMonitorListenerMulticaster(serverMonitorListeners);
    }

    @Nullable
    public static CommandListener getCommandListener(List<CommandListener> commandListeners) {
        switch (commandListeners.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return commandListeners.get(0);
            }
        }
        return new CommandListenerMulticaster(commandListeners);
    }

    public static ConnectionPoolListener getConnectionPoolListener(ConnectionPoolSettings connectionPoolSettings) {
        switch (connectionPoolSettings.getConnectionPoolListeners().size()) {
            case 0: {
                return NO_OP_CONNECTION_POOL_LISTENER;
            }
            case 1: {
                return connectionPoolSettings.getConnectionPoolListeners().get(0);
            }
        }
        return new ConnectionPoolListenerMulticaster(connectionPoolSettings.getConnectionPoolListeners());
    }

    private EventListenerHelper() {
    }
}

