/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBoolean;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonInt64;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.FieldNameValidator;
import com.dre.brewery.depend.bson.codecs.BsonValueCodecProvider;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistries;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.mongodb.MongoBulkWriteException;
import com.dre.brewery.depend.mongodb.MongoInternalException;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.WriteConcern;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.bulk.BulkWriteError;
import com.dre.brewery.depend.mongodb.bulk.BulkWriteInsert;
import com.dre.brewery.depend.mongodb.bulk.BulkWriteResult;
import com.dre.brewery.depend.mongodb.bulk.BulkWriteUpsert;
import com.dre.brewery.depend.mongodb.bulk.WriteConcernError;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.internal.bulk.DeleteRequest;
import com.dre.brewery.depend.mongodb.internal.bulk.UpdateRequest;
import com.dre.brewery.depend.mongodb.internal.bulk.WriteRequest;
import com.dre.brewery.depend.mongodb.internal.bulk.WriteRequestWithIndex;
import com.dre.brewery.depend.mongodb.internal.connection.BulkWriteBatchCombiner;
import com.dre.brewery.depend.mongodb.internal.connection.IndexMap;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.connection.SplittablePayload;
import com.dre.brewery.depend.mongodb.internal.operation.DocumentHelper;
import com.dre.brewery.depend.mongodb.internal.operation.MixedBulkWriteOperation;
import com.dre.brewery.depend.mongodb.internal.operation.OperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.WriteConcernHelper;
import com.dre.brewery.depend.mongodb.internal.session.SessionContext;
import com.dre.brewery.depend.mongodb.internal.validator.MappedFieldNameValidator;
import com.dre.brewery.depend.mongodb.internal.validator.NoOpFieldNameValidator;
import com.dre.brewery.depend.mongodb.internal.validator.ReplacingDocumentFieldNameValidator;
import com.dre.brewery.depend.mongodb.internal.validator.UpdateFieldNameValidator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class BulkWriteBatch {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final Decoder<BsonDocument> DECODER = REGISTRY.get(BsonDocument.class);
    private final MongoNamespace namespace;
    private final ConnectionDescription connectionDescription;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private final Boolean bypassDocumentValidation;
    private final boolean retryWrites;
    private final BulkWriteBatchCombiner bulkWriteBatchCombiner;
    private final IndexMap indexMap;
    private final WriteRequest.Type batchType;
    private final BsonDocument command;
    private final SplittablePayload payload;
    private final List<WriteRequestWithIndex> unprocessed;
    private final OperationContext operationContext;
    private final BsonValue comment;
    private final BsonDocument variables;

    static BulkWriteBatch createBulkWriteBatch(MongoNamespace namespace, ConnectionDescription connectionDescription, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, boolean retryWrites, List<? extends WriteRequest> writeRequests, OperationContext operationContext, @Nullable BsonValue comment, @Nullable BsonDocument variables) {
        boolean canRetryWrites = OperationHelper.isRetryableWrite(retryWrites, writeConcern, connectionDescription, operationContext.getSessionContext());
        ArrayList<WriteRequestWithIndex> writeRequestsWithIndex = new ArrayList<WriteRequestWithIndex>();
        boolean writeRequestsAreRetryable = true;
        for (int i = 0; i < writeRequests.size(); ++i) {
            WriteRequest writeRequest = writeRequests.get(i);
            writeRequestsAreRetryable = writeRequestsAreRetryable && BulkWriteBatch.isRetryable(writeRequest);
            writeRequestsWithIndex.add(new WriteRequestWithIndex(writeRequest, i));
        }
        if (canRetryWrites && !writeRequestsAreRetryable) {
            canRetryWrites = false;
            OperationHelper.LOGGER.debug("retryWrites set but one or more writeRequests do not support retryable writes");
        }
        return new BulkWriteBatch(namespace, connectionDescription, ordered, writeConcern, bypassDocumentValidation, canRetryWrites, new BulkWriteBatchCombiner(connectionDescription.getServerAddress(), ordered, writeConcern), writeRequestsWithIndex, operationContext, comment, variables);
    }

    private BulkWriteBatch(MongoNamespace namespace, ConnectionDescription connectionDescription, boolean ordered, WriteConcern writeConcern, @Nullable Boolean bypassDocumentValidation, boolean retryWrites, BulkWriteBatchCombiner bulkWriteBatchCombiner, List<WriteRequestWithIndex> writeRequestsWithIndices, OperationContext operationContext, @Nullable BsonValue comment, @Nullable BsonDocument variables) {
        this.namespace = namespace;
        this.connectionDescription = connectionDescription;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
        this.bypassDocumentValidation = bypassDocumentValidation;
        this.bulkWriteBatchCombiner = bulkWriteBatchCombiner;
        this.batchType = writeRequestsWithIndices.isEmpty() ? WriteRequest.Type.INSERT : writeRequestsWithIndices.get(0).getType();
        this.retryWrites = retryWrites;
        ArrayList<WriteRequestWithIndex> payloadItems = new ArrayList<WriteRequestWithIndex>();
        ArrayList<WriteRequestWithIndex> unprocessedItems = new ArrayList<WriteRequestWithIndex>();
        IndexMap indexMap = IndexMap.create();
        for (int i = 0; i < writeRequestsWithIndices.size(); ++i) {
            WriteRequestWithIndex writeRequestWithIndex = writeRequestsWithIndices.get(i);
            if (writeRequestWithIndex.getType() != this.batchType) {
                if (ordered) {
                    unprocessedItems.addAll(writeRequestsWithIndices.subList(i, writeRequestsWithIndices.size()));
                    break;
                }
                unprocessedItems.add(writeRequestWithIndex);
                continue;
            }
            indexMap = indexMap.add(payloadItems.size(), writeRequestWithIndex.getIndex());
            payloadItems.add(writeRequestWithIndex);
        }
        this.indexMap = indexMap;
        this.unprocessed = unprocessedItems;
        this.payload = new SplittablePayload(this.getPayloadType(this.batchType), payloadItems, ordered);
        this.operationContext = operationContext;
        this.comment = comment;
        this.variables = variables;
        this.command = new BsonDocument();
        SessionContext sessionContext = operationContext.getSessionContext();
        if (!payloadItems.isEmpty()) {
            this.command.put(this.getCommandName(this.batchType), new BsonString(namespace.getCollectionName()));
            this.command.put("ordered", new BsonBoolean(ordered));
            MixedBulkWriteOperation.commandWriteConcern(writeConcern, sessionContext).ifPresent(value -> this.command.put("writeConcern", value.asDocument()));
            if (bypassDocumentValidation != null) {
                this.command.put("bypassDocumentValidation", new BsonBoolean(bypassDocumentValidation));
            }
            DocumentHelper.putIfNotNull(this.command, "comment", comment);
            DocumentHelper.putIfNotNull(this.command, "let", variables);
            if (retryWrites) {
                this.command.put("txnNumber", new BsonInt64(sessionContext.advanceTransactionNumber()));
            }
        }
    }

    private BulkWriteBatch(MongoNamespace namespace, ConnectionDescription connectionDescription, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, boolean retryWrites, BulkWriteBatchCombiner bulkWriteBatchCombiner, IndexMap indexMap, WriteRequest.Type batchType, BsonDocument command, SplittablePayload payload, List<WriteRequestWithIndex> unprocessed, OperationContext operationContext, @Nullable BsonValue comment, @Nullable BsonDocument variables) {
        this.namespace = namespace;
        this.connectionDescription = connectionDescription;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
        this.bypassDocumentValidation = bypassDocumentValidation;
        this.bulkWriteBatchCombiner = bulkWriteBatchCombiner;
        this.indexMap = indexMap;
        this.batchType = batchType;
        this.payload = payload;
        this.unprocessed = unprocessed;
        this.retryWrites = retryWrites;
        this.operationContext = operationContext;
        this.comment = comment;
        this.variables = variables;
        if (retryWrites) {
            command.put("txnNumber", new BsonInt64(operationContext.getSessionContext().advanceTransactionNumber()));
        }
        this.command = command;
    }

    void addResult(@Nullable BsonDocument result) {
        if (this.writeConcern.isAcknowledged()) {
            if (this.hasError(Assertions.assertNotNull(result))) {
                MongoBulkWriteException bulkWriteException = this.getBulkWriteException(result);
                this.bulkWriteBatchCombiner.addErrorResult(bulkWriteException, this.indexMap);
            } else {
                this.bulkWriteBatchCombiner.addResult(this.getBulkWriteResult(result));
            }
        }
    }

    boolean getRetryWrites() {
        return this.retryWrites;
    }

    BsonDocument getCommand() {
        return this.command;
    }

    SplittablePayload getPayload() {
        return this.payload;
    }

    Decoder<BsonDocument> getDecoder() {
        return DECODER;
    }

    BulkWriteResult getResult() {
        return this.bulkWriteBatchCombiner.getResult();
    }

    boolean hasErrors() {
        return this.bulkWriteBatchCombiner.hasErrors();
    }

    @Nullable
    MongoBulkWriteException getError() {
        return this.bulkWriteBatchCombiner.getError();
    }

    boolean shouldProcessBatch() {
        return !this.bulkWriteBatchCombiner.shouldStopSendingMoreBatches() && !this.payload.isEmpty();
    }

    boolean hasAnotherBatch() {
        return !this.unprocessed.isEmpty();
    }

    BulkWriteBatch getNextBatch() {
        if (this.payload.hasAnotherSplit()) {
            IndexMap nextIndexMap = IndexMap.create();
            int newIndex = 0;
            for (int i = this.payload.getPosition(); i < this.payload.size(); ++i) {
                nextIndexMap = nextIndexMap.add(newIndex, this.indexMap.map(i));
                ++newIndex;
            }
            return new BulkWriteBatch(this.namespace, this.connectionDescription, this.ordered, this.writeConcern, this.bypassDocumentValidation, this.retryWrites, this.bulkWriteBatchCombiner, nextIndexMap, this.batchType, this.command, this.payload.getNextSplit(), this.unprocessed, this.operationContext, this.comment, this.variables);
        }
        return new BulkWriteBatch(this.namespace, this.connectionDescription, this.ordered, this.writeConcern, this.bypassDocumentValidation, this.retryWrites, this.bulkWriteBatchCombiner, this.unprocessed, this.operationContext, this.comment, this.variables);
    }

    FieldNameValidator getFieldNameValidator() {
        if (this.batchType == WriteRequest.Type.UPDATE || this.batchType == WriteRequest.Type.REPLACE) {
            Map<String, FieldNameValidator> rootMap = this.batchType == WriteRequest.Type.REPLACE ? Collections.singletonMap("u", ReplacingDocumentFieldNameValidator.INSTANCE) : Collections.singletonMap("u", new UpdateFieldNameValidator());
            return new MappedFieldNameValidator(NoOpFieldNameValidator.INSTANCE, rootMap);
        }
        return NoOpFieldNameValidator.INSTANCE;
    }

    private BulkWriteResult getBulkWriteResult(BsonDocument result) {
        int count = result.getNumber("n").intValue();
        List<BulkWriteInsert> insertedItems = this.getInsertedItems(result);
        List<BulkWriteUpsert> upsertedItems = this.getUpsertedItems(result);
        return BulkWriteResult.acknowledged(this.batchType, count - upsertedItems.size(), this.getModifiedCount(result), upsertedItems, insertedItems);
    }

    private List<BulkWriteInsert> getInsertedItems(BsonDocument result) {
        Set writeErrors = this.getWriteErrors(result).stream().map(BulkWriteError::getIndex).collect(Collectors.toSet());
        return this.payload.getInsertedIds().entrySet().stream().filter(entry -> !writeErrors.contains(entry.getKey())).map(entry -> new BulkWriteInsert((Integer)entry.getKey(), (BsonValue)entry.getValue())).collect(Collectors.toList());
    }

    private List<BulkWriteUpsert> getUpsertedItems(BsonDocument result) {
        BsonArray upsertedValue = result.getArray("upserted", new BsonArray());
        ArrayList<BulkWriteUpsert> bulkWriteUpsertList = new ArrayList<BulkWriteUpsert>();
        for (BsonValue upsertedItem : upsertedValue) {
            BsonDocument upsertedItemDocument = (BsonDocument)upsertedItem;
            bulkWriteUpsertList.add(new BulkWriteUpsert(this.indexMap.map(upsertedItemDocument.getNumber("index").intValue()), upsertedItemDocument.get("_id")));
        }
        return bulkWriteUpsertList;
    }

    private int getModifiedCount(BsonDocument result) {
        return result.getNumber("nModified", new BsonInt32(0)).intValue();
    }

    private boolean hasError(BsonDocument result) {
        return result.get("writeErrors") != null || result.get("writeConcernError") != null;
    }

    private MongoBulkWriteException getBulkWriteException(BsonDocument result) {
        if (!this.hasError(result)) {
            throw new MongoInternalException("This method should not have been called");
        }
        return new MongoBulkWriteException(this.getBulkWriteResult(result), this.getWriteErrors(result), this.getWriteConcernError(result), this.connectionDescription.getServerAddress(), result.getArray("errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).collect(Collectors.toSet()));
    }

    private List<BulkWriteError> getWriteErrors(BsonDocument result) {
        ArrayList<BulkWriteError> writeErrors = new ArrayList<BulkWriteError>();
        BsonArray writeErrorsDocuments = (BsonArray)result.get("writeErrors");
        if (writeErrorsDocuments != null) {
            for (BsonValue cur : writeErrorsDocuments) {
                BsonDocument curDocument = (BsonDocument)cur;
                writeErrors.add(new BulkWriteError(curDocument.getNumber("code").intValue(), curDocument.getString("errmsg").getValue(), curDocument.getDocument("errInfo", new BsonDocument()), curDocument.getNumber("index").intValue()));
            }
        }
        return writeErrors;
    }

    @Nullable
    private WriteConcernError getWriteConcernError(BsonDocument result) {
        BsonDocument writeConcernErrorDocument = (BsonDocument)result.get("writeConcernError");
        if (writeConcernErrorDocument == null) {
            return null;
        }
        return WriteConcernHelper.createWriteConcernError(writeConcernErrorDocument);
    }

    private String getCommandName(WriteRequest.Type batchType) {
        if (batchType == WriteRequest.Type.INSERT) {
            return "insert";
        }
        if (batchType == WriteRequest.Type.UPDATE || batchType == WriteRequest.Type.REPLACE) {
            return "update";
        }
        return "delete";
    }

    private SplittablePayload.Type getPayloadType(WriteRequest.Type batchType) {
        if (batchType == WriteRequest.Type.INSERT) {
            return SplittablePayload.Type.INSERT;
        }
        if (batchType == WriteRequest.Type.UPDATE) {
            return SplittablePayload.Type.UPDATE;
        }
        if (batchType == WriteRequest.Type.REPLACE) {
            return SplittablePayload.Type.REPLACE;
        }
        return SplittablePayload.Type.DELETE;
    }

    private static boolean isRetryable(WriteRequest writeRequest) {
        if (writeRequest.getType() == WriteRequest.Type.UPDATE || writeRequest.getType() == WriteRequest.Type.REPLACE) {
            return !((UpdateRequest)writeRequest).isMulti();
        }
        if (writeRequest.getType() == WriteRequest.Type.DELETE) {
            return !((DeleteRequest)writeRequest).isMulti();
        }
        return true;
    }
}

