/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.mongodb.MongoChangeStreamException;
import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.MongoCursorNotFoundException;
import com.dre.brewery.depend.mongodb.MongoException;
import com.dre.brewery.depend.mongodb.MongoInterruptedException;
import com.dre.brewery.depend.mongodb.MongoNotPrimaryException;
import com.dre.brewery.depend.mongodb.MongoOperationTimeoutException;
import com.dre.brewery.depend.mongodb.MongoSocketException;
import java.util.Arrays;
import java.util.List;

final class ChangeStreamBatchCursorHelper {
    static final List<Integer> RETRYABLE_SERVER_ERROR_CODES = Arrays.asList(6, 7, 63, 89, 91, 133, 150, 189, 234, 262, 9001, 10107, 11600, 11602, 13388, 13435, 13436);
    static final String RESUMABLE_CHANGE_STREAM_ERROR_LABEL = "ResumableChangeStreamError";

    static boolean isResumableError(Throwable t, int maxWireVersion) {
        if (!(t instanceof MongoException) || t instanceof MongoChangeStreamException || t instanceof MongoInterruptedException || t instanceof MongoOperationTimeoutException) {
            return false;
        }
        if (t instanceof MongoNotPrimaryException || t instanceof MongoCursorNotFoundException || t instanceof MongoSocketException | t instanceof MongoClientException) {
            return true;
        }
        if (maxWireVersion >= 9) {
            return ((MongoException)t).getErrorLabels().contains(RESUMABLE_CHANGE_STREAM_ERROR_LABEL);
        }
        return RETRYABLE_SERVER_ERROR_CODES.contains(((MongoException)t).getCode());
    }

    private ChangeStreamBatchCursorHelper() {
    }
}

