/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.barrel;

import com.dre.brewery.integration.barrel.WGBarrel;
import com.dre.brewery.utility.Logging;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WGBarrel5
implements WGBarrel {
    private Method allows;
    private Method canBuild;
    private Method getApplicableRegions;

    public WGBarrel5() {
        try {
            this.allows = ApplicableRegionSet.class.getMethod("allows", StateFlag.class, LocalPlayer.class);
            this.canBuild = ApplicableRegionSet.class.getMethod("canBuild", LocalPlayer.class);
            this.getApplicableRegions = RegionManager.class.getMethod("getApplicableRegions", Location.class);
        }
        catch (NoSuchMethodException e) {
            Logging.errorLog("Failed to Hook WorldGuard for Barrel Open Permissions! Opening Barrels will NOT work!", e);
            Logging.errorLog("Brewery was tested with version 5.8, 6.1 to 7.0 of WorldGuard!");
            Logging.errorLog("Disable the WorldGuard support in the config and do /brew reload");
        }
    }

    @Override
    public boolean checkAccess(Player player, Block spigot, Plugin plugin) {
        WorldGuardPlugin wg = (WorldGuardPlugin)plugin;
        if (!wg.getGlobalRegionManager().hasBypass(player, player.getWorld())) {
            try {
                LocalPlayer localPlayer;
                Object region = this.getApplicableRegions.invoke((Object)wg.getRegionManager(player.getWorld()), spigot.getLocation());
                if (region != null && !((Boolean)this.allows.invoke(region, DefaultFlag.CHEST_ACCESS, localPlayer = wg.wrapPlayer(player))).booleanValue() && !((Boolean)this.canBuild.invoke(region, localPlayer)).booleanValue()) {
                    return false;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Logging.errorLog("Failed to check WorldGuard Barrel Access!", e);
                return false;
            }
        }
        return true;
    }
}

