/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.bstats;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.integration.bstats.Metrics;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.utility.Logging;
import java.util.HashMap;

public class BreweryXStats {
    private static final int BSTATS_ID = 24059;
    private final Config config = ConfigManager.getConfig(Config.class);

    private String getBranch() {
        String versionString = BreweryPlugin.getInstance().getDescription().getVersion();
        if (versionString.contains(";")) {
            return versionString.split(";")[1];
        }
        return "unknown";
    }

    public void setupBStats() {
        try {
            Metrics metrics = new Metrics(BreweryPlugin.getInstance(), 24059);
            metrics.addCustomChart(new Metrics.DrilldownPie("storage_type", () -> {
                HashMap map = new HashMap();
                String storageType = BreweryPlugin.getDataManager().getType().getFormattedName();
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(storageType, 1);
                map.put(storageType, entry);
                return map;
            }));
            metrics.addCustomChart(new Metrics.AdvancedPie("recipe_count", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                int recipeCount = BRecipe.getAllRecipes().size();
                if (recipeCount >= 150) {
                    valueMap.put("150+", recipeCount);
                } else if (recipeCount >= 100) {
                    valueMap.put("100-149", recipeCount);
                } else if (recipeCount >= 50) {
                    valueMap.put("50-99", recipeCount);
                } else if (recipeCount >= 25) {
                    valueMap.put("25-49", recipeCount);
                } else if (recipeCount >= 10) {
                    valueMap.put("10-24", recipeCount);
                } else if (recipeCount >= 5) {
                    valueMap.put("5-9", recipeCount);
                } else {
                    valueMap.put("1-4", recipeCount);
                }
                return valueMap;
            }));
            metrics.addCustomChart(new Metrics.AdvancedPie("addons", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                int addonsAmount = BreweryPlugin.getAddonManager().getAddons().size();
                if (addonsAmount >= 5) {
                    valueMap.put("5+", addonsAmount);
                } else if (addonsAmount >= 3) {
                    valueMap.put("3-4", addonsAmount);
                } else if (addonsAmount == 2) {
                    valueMap.put("2", addonsAmount);
                } else if (addonsAmount == 1) {
                    valueMap.put("1", addonsAmount);
                } else {
                    valueMap.put("0", addonsAmount);
                }
                return valueMap;
            }));
            metrics.addCustomChart(new Metrics.SimplePie("language", this.config::getLanguage));
            metrics.addCustomChart(new Metrics.SimplePie("branch", this::getBranch));
            metrics.addCustomChart(new Metrics.SingleLineChart("drunk_players", BPlayer::numDrunkPlayers));
            metrics.addCustomChart(new Metrics.SingleLineChart("barrels_built", Barrel.getAllBarrels()::size));
            metrics.addCustomChart(new Metrics.SingleLineChart("cauldrons_boiling", BCauldron.bcauldrons::size));
        }
        catch (Exception | LinkageError e) {
            Logging.errorLog("Failed to submit stats data to bStats.org (BreweryXStats)", e);
        }
    }
}

