/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.listeners;

import com.dre.brewery.Barrel;
import com.dre.brewery.BarrelAsset;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.barrel.BarrelAccessEvent;
import com.dre.brewery.api.events.barrel.BarrelDestroyEvent;
import com.dre.brewery.api.events.barrel.BarrelRemoveEvent;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.integration.BlockLockerHook;
import com.dre.brewery.integration.Hook;
import com.dre.brewery.integration.WorldGuarkHook;
import com.dre.brewery.integration.barrel.BlockLockerBarrel;
import com.dre.brewery.integration.barrel.GriefPreventionBarrel;
import com.dre.brewery.integration.barrel.LWCBarrel;
import com.dre.brewery.integration.barrel.LandsBarrel;
import com.dre.brewery.integration.barrel.LogBlockBarrel;
import com.dre.brewery.integration.barrel.TownyBarrel;
import com.dre.brewery.integration.item.MMOItemsPluginItem;
import com.dre.brewery.listeners.PlayerListener;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MaterialUtil;
import com.dre.brewery.utility.MinecraftVersion;
import io.lumine.mythic.lib.api.item.NBTItem;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class IntegrationListener
implements Listener {
    private final Config config = ConfigManager.getConfig(Config.class);
    private final Lang lang = ConfigManager.getConfig(Lang.class);

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBarrelAccessLowest(BarrelAccessEvent event) {
        Plugin plugin;
        WorldGuarkHook hook = WorldGuarkHook.WORLDGUARD;
        if (hook.isEnabled() && (plugin = hook.getPlugin()) != null) {
            try {
                if (!hook.getWgBarrel().checkAccess(event.getPlayer(), event.getSpigot(), plugin)) {
                    event.setCancelled(true);
                    this.lang.sendEntry((CommandSender)event.getPlayer(), "Error_NoBarrelAccess", new Object[0]);
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                Logging.errorLog("Failed to Check WorldGuard for Barrel Open Permissions!", e);
                Logging.errorLog("Brewery was tested with version 5.8, 6.1 to 7.0 of WorldGuard!");
                Logging.errorLog("Disable the WorldGuard support in the config and do /brew reload");
                Player player = event.getPlayer();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    Logging.msg((CommandSender)player, "&cWorldGuard check Error, Brewery was tested with up to v7.0 of Worldguard");
                    Logging.msg((CommandSender)player, "&cSet &7useWorldGuard: false &cin the config and /brew reload");
                }
                Logging.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBarrelAccess(BarrelAccessEvent event) {
        Block sign;
        Player player;
        Hook hook = Hook.GAMEMODEINVENTORIES;
        if (hook.isEnabled()) {
            Plugin pl = hook.getPlugin();
            if (pl != null && pl.isEnabled()) {
                try {
                    if (pl.getConfig().getBoolean("restrict_creative") && (player = event.getPlayer()).getGameMode() == GameMode.CREATIVE && (!pl.getConfig().getBoolean("bypass.inventories") || !player.hasPermission("gamemodeinventories.bypass") && !player.isOp())) {
                        event.setCancelled(true);
                        if (!pl.getConfig().getBoolean("dont_spam_chat")) {
                            this.lang.sendEntry((CommandSender)event.getPlayer(), "Error_NoBarrelAccess", new Object[0]);
                        }
                        return;
                    }
                }
                catch (Throwable e) {
                    Logging.errorLog("Failed to Check GameModeInventories for Barrel Open Permissions!", e);
                    Logging.errorLog("Players will be able to open Barrel with GameMode Creative");
                    hook.setEnabled(false);
                }
            } else {
                hook.setEnabled(false);
            }
        }
        if (Hook.GRIEFPREVENTION.isEnabled()) {
            try {
                if (!GriefPreventionBarrel.checkAccess(event)) {
                    this.lang.sendEntry((CommandSender)event.getPlayer(), "Error_NoBarrelAccess", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                Logging.errorLog("Failed to Check GriefPrevention for Barrel Open Permissions!", e);
                Logging.errorLog("Brewery was tested with GriefPrevention v14.5 - v16.9");
                Logging.errorLog("Disable the GriefPrevention support in the config and do /brew reload");
                player = event.getPlayer();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    Logging.msg((CommandSender)player, "&cGriefPrevention check Error, Brewery was tested with up to v16.9 of GriefPrevention");
                    Logging.msg((CommandSender)player, "&cSet &7useGriefPrevention: false &cin the config and /brew reload");
                } else {
                    Logging.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return;
            }
        }
        if (Hook.LWC.isEnabled() && !BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, event.getClickedBlock().getType()) && !(sign = event.getBarrel().getSignOfSpigot()).equals((Object)event.getClickedBlock())) {
            player = event.getPlayer();
            try {
                if (!LWCBarrel.checkAccess(player, sign, Hook.LWC.getPlugin())) {
                    this.lang.sendEntry((CommandSender)event.getPlayer(), "Error_NoBarrelAccess", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                Logging.errorLog("Failed to Check LWC for Barrel Open Permissions!", e);
                Logging.errorLog("Brewery was tested with version 4.5.0 of LWC!");
                Logging.errorLog("Disable the LWC support in the config and do /brew reload");
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    Logging.msg((CommandSender)player, "&cLWC check Error, Brewery was tested with up to v4.5.0 of LWC");
                    Logging.msg((CommandSender)player, "&cSet &7useLWC: false &cin the config and /brew reload");
                } else {
                    Logging.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return;
            }
        }
        if (Hook.TOWNY.isEnabled()) {
            try {
                if (!TownyBarrel.checkAccess(event)) {
                    this.lang.sendEntry((CommandSender)event.getPlayer(), "Error_NoBarrelAccess", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                Logging.errorLog("Failed to Check Towny for Barrel Open Permissions!", e);
                Logging.errorLog("Brewery was tested with Towny v0.96.3.0");
                Logging.errorLog("Disable the Towny support in the config and do /brew reload");
                player = event.getPlayer();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    Logging.msg((CommandSender)player, "&cTowny check Error, Brewery was tested with up to v0.96.3.0 of Towny");
                    Logging.msg((CommandSender)player, "&cSet &7useTowny: false &cin the config and /brew reload");
                } else {
                    Logging.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return;
            }
        }
        if (Hook.LANDS.isEnabled() && !LandsBarrel.checkAccess(event)) {
            this.lang.sendEntry((CommandSender)event.getPlayer(), "Error_NoBarrelAccess", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (BlockLockerHook.BLOCKLOCKER.isEnabled()) {
            try {
                if (!BlockLockerBarrel.checkAccess(event)) {
                    this.lang.sendEntry((CommandSender)event.getPlayer(), "Error_NoBarrelAccess", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                Logging.errorLog("Failed to Check BlockLocker for Barrel Open Permissions!", e);
                Logging.errorLog("Brewery was tested with BlockLocker v1.9");
                Logging.errorLog("Disable the BlockLocker support in the config and do /brew reload");
                player = event.getPlayer();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    Logging.msg((CommandSender)player, "&cBlockLocker check Error, Brewery was tested with v1.9 of BlockLocker");
                    Logging.msg((CommandSender)player, "&cSet &7useBlockLocker: false &cin the config and /brew reload");
                } else {
                    Logging.msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return;
            }
        }
        if (this.config.isUseVirtualChestPerms()) {
            Player player2 = event.getPlayer();
            BlockState originalBlockState = PaperLib.getBlockState(event.getClickedBlock(), true).getState();
            event.getClickedBlock().setType(Material.CHEST, false);
            PlayerInteractEvent simulatedEvent = new PlayerInteractEvent(player2, Action.RIGHT_CLICK_BLOCK, player2.getInventory().getItemInMainHand(), event.getClickedBlock(), event.getClickedBlockFace(), EquipmentSlot.HAND);
            try {
                BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)simulatedEvent);
            }
            catch (Throwable e) {
                Logging.errorLog("Failed to simulate a Chest for Barrel Open Permissions!", e);
                Logging.errorLog("Disable useVirtualChestPerms in the config and do /brew reload");
                if (player2.hasPermission("brewery.admin") || player2.hasPermission("brewery.mod")) {
                    Logging.msg((CommandSender)player2, "&cVirtual Chest Error");
                    Logging.msg((CommandSender)player2, "&cSet &7useVirtualChestPerms: false &cin the config and /brew reload");
                } else {
                    Logging.msg((CommandSender)player2, "&cError opening Barrel, please report to an Admin!");
                }
            }
            finally {
                event.getClickedBlock().setType(Material.AIR, false);
                originalBlockState.update(true);
            }
            if (simulatedEvent.useInteractedBlock() == Event.Result.DENY) {
                event.setCancelled(true);
                this.lang.sendEntry((CommandSender)event.getPlayer(), "Error_NoBarrelAccess", new Object[0]);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onBarrelDestroy(BarrelDestroyEvent event) {
        block14: {
            if (!Hook.LWC.isEnabled()) {
                return;
            }
            if (event.hasPlayer()) {
                Player player = event.getPlayerOptional();
                assert (player != null);
                try {
                    if (LWCBarrel.denyDestroy(player, event.getBarrel())) {
                        event.setCancelled(true);
                    }
                }
                catch (Throwable e) {
                    event.setCancelled(true);
                    Logging.errorLog("Failed to Check LWC for Barrel Break Permissions!", e);
                    Logging.errorLog("Brewery was tested with version 4.5.0 of LWC!");
                    Logging.errorLog("Disable the LWC support in the config and do /brew reload");
                    if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                        Logging.msg((CommandSender)player, "&cLWC check Error, Brewery was tested with up to v4.5.0 of LWC");
                        Logging.msg((CommandSender)player, "&cSet &7useLWC: false &cin the config and /brew reload");
                        break block14;
                    }
                    Logging.msg((CommandSender)player, "&cError breaking Barrel, please report to an Admin!");
                }
            } else {
                try {
                    if (event.getReason() == BarrelDestroyEvent.Reason.EXPLODED) {
                        if (LWCBarrel.denyExplosion(event.getBarrel())) {
                            event.setCancelled(true);
                        }
                    } else if (LWCBarrel.denyDestroyOther(event.getBarrel())) {
                        event.setCancelled(true);
                    }
                }
                catch (Throwable e) {
                    event.setCancelled(true);
                    Logging.errorLog("Failed to Check LWC on Barrel Destruction!", e);
                    Logging.errorLog("Brewery was tested with version 4.5.0 of LWC!");
                    Logging.errorLog("Disable the LWC support in the config and do /brew reload");
                }
            }
        }
    }

    @EventHandler
    public void onBarrelRemove(BarrelRemoveEvent event) {
        if (!Hook.LWC.isEnabled()) {
            return;
        }
        try {
            LWCBarrel.remove(event.getBarrel());
        }
        catch (Throwable e) {
            Logging.errorLog("Failed to Remove LWC Lock from Barrel!", e);
            Logging.errorLog("Brewery was tested with version 4.5.0 of LWC!");
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!Hook.LOGBLOCK.isEnabled()) {
            return;
        }
        if (PaperLib.getHolder(event.getInventory(), true).getHolder() instanceof Barrel) {
            try {
                LogBlockBarrel.closeBarrel(event.getPlayer(), event.getInventory());
            }
            catch (Exception e) {
                Logging.errorLog("Failed to Log Barrel to LogBlock!", e);
                Logging.errorLog("Brewery was tested with version 1.94 of LogBlock!");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        if (BreweryPlugin.getMCVersion().isOrEarlier(MinecraftVersion.V1_9)) {
            return;
        }
        if (!Hook.MMOITEMS.isEnabled()) {
            return;
        }
        try {
            NBTItem item;
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.hasItem() && event.getHand() == EquipmentSlot.HAND && event.getClickedBlock() != null && MaterialUtil.isWaterCauldron(event.getClickedBlock().getType()) && (item = NBTItem.get((ItemStack)event.getItem())).hasType()) {
                for (RecipeItem rItem : BCauldronRecipe.acceptedCustom) {
                    MMOItemsPluginItem mmo;
                    if (!(rItem instanceof MMOItemsPluginItem) || !(mmo = (MMOItemsPluginItem)rItem).matches(event.getItem())) continue;
                    event.setCancelled(true);
                    PlayerListener.handlePlayerInteract(event);
                    return;
                }
            }
        }
        catch (Throwable e) {
            Logging.errorLog("Could not check MMOItems for Item", e);
            Hook.MMOITEMS.setEnabled(false);
        }
    }
}

