/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.listeners.movecraft;

import com.dre.brewery.Barrel;
import com.dre.brewery.integration.listeners.movecraft.MovecraftUtil;
import com.dre.brewery.utility.BoundingBox;
import javax.annotation.Nullable;
import net.countercraft.movecraft.MovecraftLocation;
import net.countercraft.movecraft.craft.Craft;
import net.countercraft.movecraft.events.CraftTranslateEvent;
import net.countercraft.movecraft.util.hitboxes.HitBox;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class TranslationListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void translateListener(CraftTranslateEvent event) {
        Vector delta = this.delta(event);
        if (delta == null) {
            return;
        }
        Craft craft = event.getCraft();
        HitBox hitBox = craft.getHitBox();
        for (Barrel barrel : MovecraftUtil.barrelsOnCraft(hitBox, craft.getWorld())) {
            Location location = barrel.getSpigot().getLocation();
            BoundingBox box = barrel.getBounds();
            box.setMin(this.move(box.getMin(), delta));
            box.setMax(this.move(box.getMax(), delta));
            barrel.setSpigot(location.add(delta.getX(), delta.getY(), delta.getZ()).getBlock());
        }
    }

    @Nullable
    private Vector delta(@NotNull CraftTranslateEvent event) {
        if (event.getOldHitBox().isEmpty() || event.getNewHitBox().isEmpty()) {
            return null;
        }
        MovecraftLocation oldMid = event.getOldHitBox().getMidPoint();
        MovecraftLocation newMid = event.getNewHitBox().getMidPoint();
        int dx = newMid.getX() - oldMid.getX();
        int dy = newMid.getY() - oldMid.getY();
        int dz = newMid.getZ() - oldMid.getZ();
        return new Vector(dx, dy, dz);
    }

    @NotNull
    private BoundingBox.BlockPos move(@NotNull BoundingBox.BlockPos pos, @NotNull Vector vec) {
        return new BoundingBox.BlockPos(pos.x() + vec.getBlockX(), pos.y() + vec.getBlockY(), pos.z() + vec.getBlockZ());
    }
}

