/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.listeners.movecraft.properties;

import com.dre.brewery.BarrelAsset;
import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.integration.listeners.movecraft.properties.MaxBarrelEntry;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.countercraft.movecraft.craft.type.CraftType;
import net.countercraft.movecraft.craft.type.TypeData;
import net.countercraft.movecraft.craft.type.property.BooleanProperty;
import net.countercraft.movecraft.craft.type.property.ObjectPropertyImpl;
import net.countercraft.movecraft.craft.type.property.Property;
import net.countercraft.movecraft.craft.type.transform.MaterialSetTransform;
import net.countercraft.movecraft.craft.type.transform.Transform;
import net.countercraft.movecraft.util.Pair;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public class BreweryProperties {
    public static final NamespacedKey ALL_BARRELS_ALLOWED = new NamespacedKey("brewery-x", "all_barrels_allowed");
    public static final NamespacedKey MAX_BARRELS = new NamespacedKey("brewery-x", "max_barrels");

    @NotNull
    private static Pair<Boolean, ? extends Number> parseLimit(@NotNull Object input) {
        if (!(input instanceof String)) {
            return new Pair((Object)false, (Object)((Double)input));
        }
        String str = (String)input;
        if (!str.contains("N")) {
            return new Pair((Object)false, (Object)Double.valueOf(str));
        }
        String[] parts = str.split("N");
        int val = Integer.parseInt(parts[1]);
        return new Pair((Object)true, (Object)val);
    }

    public static void register() {
        CraftType.registerProperty((Property)new BooleanProperty("allBarrelsAllowed", ALL_BARRELS_ALLOWED, data -> false));
        CraftType.registerProperty((Property)new ObjectPropertyImpl("maxBarrels", MAX_BARRELS, (data, type, fileKey, namespacedKey) -> {
            Map map = data.getData(fileKey).getBackingData();
            HashSet<MaxBarrelEntry> maxBarrels = new HashSet<MaxBarrelEntry>();
            if (map.isEmpty()) {
                return maxBarrels;
            }
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new TypeData.InvalidValueException("Keys for " + fileKey + " must be a string barrel type.");
                }
                String name = ((String)entry.getKey()).toUpperCase();
                try {
                    BarrelWoodType barrelType = BarrelWoodType.valueOf(name);
                    Pair<Boolean, ? extends Number> limit = BreweryProperties.parseLimit(entry.getValue());
                    maxBarrels.add(new MaxBarrelEntry(barrelType, limit));
                }
                catch (IllegalArgumentException e) {
                    throw new TypeData.InvalidValueException("Type value of " + fileKey + " was an invalid barrel type.");
                }
            }
            return maxBarrels;
        }, type -> new HashSet()));
        CraftType.registerTypeTransform((Transform)((MaterialSetTransform)(data, type) -> {
            EnumSet set = (EnumSet)data.get(CraftType.ALLOWED_BLOCKS);
            if (type.getBoolProperty(ALL_BARRELS_ALLOWED)) {
                Arrays.stream(BarrelWoodType.values()).map(BarrelAsset::getMaterialsOf).forEach(set::addAll);
            } else {
                Set maxBarrels = (Set)type.getObjectProperty(MAX_BARRELS);
                if (maxBarrels == null) {
                    return data;
                }
                for (MaxBarrelEntry entry : maxBarrels) {
                    Set<Material> materialSet = BarrelAsset.getMaterialsOf(entry.type());
                    set.addAll(materialSet);
                }
            }
            return data;
        }));
    }
}

