/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.listeners.movecraft.properties;

import com.dre.brewery.BarrelWoodType;
import net.countercraft.movecraft.util.Pair;
import org.jetbrains.annotations.NotNull;

public record MaxBarrelEntry(BarrelWoodType type, double max, boolean numericMax) {
    public MaxBarrelEntry(BarrelWoodType name, @NotNull Pair<Boolean, ? extends Number> max) {
        this(name, ((Number)max.getRight()).doubleValue(), (Boolean)max.getLeft());
    }

    public boolean check(int count, int size) {
        if (this.numericMax) {
            return (double)count <= this.max;
        }
        double percent = 100.0 * (double)count / (double)size;
        return percent <= this.max;
    }

    public String detect(int count, int size) {
        if (this.numericMax) {
            if ((double)count > this.max) {
                return String.format("%d > %d", count, (int)this.max);
            }
        } else {
            double blockPercent = 100.0 * (double)count / (double)size;
            if (blockPercent > this.max) {
                return String.format("%.2f%% > %.2f%%", blockPercent, this.max);
            }
        }
        return null;
    }
}

