/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BCauldron;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.barrel.BarrelDestroyEvent;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.MinecraftVersion;
import java.util.ArrayList;
import java.util.ListIterator;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.inventory.ItemStack;

public class EntityListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemDespawn(ItemDespawnEvent event) {
        if (Brew.noLegacy()) {
            return;
        }
        ItemStack item = event.getEntity().getItemStack();
        if (item.getType() == Material.POTION) {
            Brew.removeLegacy(item);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Item itemEntity;
        ItemStack item;
        if (Brew.noLegacy()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Item && (item = (itemEntity = (Item)entity).getItemStack()).getType() == Material.POTION) {
            Brew.removeLegacy(item);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onExplode(EntityExplodeEvent event) {
        if (this.causedByWindCharge(event)) {
            return;
        }
        ListIterator iter = event.blockList().listIterator();
        if (!iter.hasNext()) {
            return;
        }
        ArrayList<BarrelDestroyEvent> breakEvents = new ArrayList<BarrelDestroyEvent>(6);
        block0: while (iter.hasNext()) {
            Barrel barrel;
            BarrelDestroyEvent breakEvent2;
            Block block = (Block)iter.next();
            BCauldron cauldron = BCauldron.get(block);
            if (cauldron != null) {
                BUtil.blockDestroy(block, null, BarrelDestroyEvent.Reason.EXPLODED);
                continue;
            }
            if (!breakEvents.isEmpty()) {
                for (BarrelDestroyEvent breakEvent2 : breakEvents) {
                    if (!breakEvent2.getBarrel().hasBlock(block)) continue;
                    if (!breakEvent2.isCancelled()) continue block0;
                    iter.remove();
                    continue block0;
                }
            }
            if ((barrel = Barrel.get(block)) == null) continue;
            breakEvent2 = new BarrelDestroyEvent(barrel, block, BarrelDestroyEvent.Reason.EXPLODED, null);
            BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)breakEvent2);
            breakEvents.add(breakEvent2);
            if (breakEvent2.isCancelled()) {
                iter.remove();
                continue;
            }
            barrel.remove(block, null, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockChange(EntityChangeBlockEvent event) {
        if (event.getBlock().getType().name().toUpperCase().contains("CUT_COPPER")) {
            return;
        }
        if (Barrel.get(event.getBlock()) == null) {
            return;
        }
        event.setCancelled(true);
    }

    private boolean causedByWindCharge(EntityExplodeEvent event) {
        if (!BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_21)) {
            return false;
        }
        EntityType type = event.getEntityType();
        return type == EntityType.valueOf((String)"BREEZE_WIND_CHARGE") || type == EntityType.valueOf((String)"WIND_CHARGE");
    }
}

