/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BDistiller;
import com.dre.brewery.BSealer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.lore.BrewLore;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class InventoryListener
implements Listener {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private final Config config = ConfigManager.getConfig(Config.class);
    private static final Set<InventoryAction> CLICKED_INVENTORY_ITEM_MOVE = Set.of(InventoryAction.PLACE_SOME, InventoryAction.PLACE_ONE, InventoryAction.PLACE_ALL, InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_SOME, InventoryAction.PICKUP_ONE);
    private static final Set<String> BANNED_ACTIONS = Set.of("PICKUP_ALL_INTO_BUNDLE", "PICKUP_FROM_BUNDLE", "PICKUP_SOME_INTO_BUNDLE", "PLACE_ALL_INTO_BUNDLE", "PLACE_SOME_INTO_BUNDLE");
    private HashSet<UUID> trackedBrewmen = new HashSet();

    private boolean isBrewItem(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            return Brew.get((ItemMeta)potionMeta) != null;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerOpen(InventoryOpenEvent event) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_9)) {
            return;
        }
        HumanEntity player = event.getPlayer();
        Inventory inv = event.getInventory();
        if (player == null || !(inv instanceof BrewerInventory)) {
            return;
        }
        Logging.debugLog("Starting brew inventory tracking");
        this.trackedBrewmen.add(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerClose(InventoryCloseEvent event) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_9)) {
            return;
        }
        HumanEntity player = event.getPlayer();
        Inventory inv = event.getInventory();
        if (player == null || !(inv instanceof BrewerInventory)) {
            return;
        }
        Logging.debugLog("Stopping brew inventory tracking");
        this.trackedBrewmen.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerDrag(InventoryDragEvent event) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_9)) {
            return;
        }
        if (event.getInventory() instanceof BrewerInventory) {
            this.onBrewerClick(new InventoryClickEvent(event.getView(), InventoryType.SlotType.CONTAINER, 0, ClickType.LEFT, InventoryAction.PLACE_ALL));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerClick(InventoryClickEvent event) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_9)) {
            return;
        }
        HumanEntity player = event.getWhoClicked();
        Inventory inv = event.getInventory();
        if (!(inv instanceof BrewerInventory)) {
            return;
        }
        UUID puid = player.getUniqueId();
        if (!this.trackedBrewmen.contains(puid)) {
            return;
        }
        if (InventoryType.BREWING != inv.getType()) {
            return;
        }
        if (event.getAction() == InventoryAction.NOTHING) {
            return;
        }
        BDistiller.distillerClick(event);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBrew(BrewEvent event) {
        if (VERSION.isOrLater(MinecraftVersion.V1_9)) {
            if (BDistiller.hasBrew(event.getContents(), BDistiller.getDistillContents(event.getContents())) != 0) {
                event.setCancelled(true);
            }
            return;
        }
        if (BDistiller.runDistill(event.getContents(), BDistiller.getDistillContents(event.getContents()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onInventoryClickLow(InventoryClickEvent event) {
        ItemStack item;
        if (event.getCurrentItem() != null && event.getCurrentItem().getType().equals((Object)Material.POTION) && (item = event.getCurrentItem()).hasItemMeta()) {
            Brew brew;
            PotionMeta potion = (PotionMeta)item.getItemMeta();
            assert (potion != null);
            if (VERSION.isOrLater(MinecraftVersion.V1_11)) {
                Brew brew2;
                if (potion.getColor() == null && (brew2 = Brew.get((ItemMeta)potion)) != null) {
                    brew2.convertPre1_11(item);
                }
            } else if (VERSION.isOrLater(MinecraftVersion.V1_9) && !potion.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES) && (brew = Brew.get((ItemMeta)potion)) != null) {
                brew.convertPre1_9(item);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Stream<ItemStack> relatedItems;
        ItemStack hotbarItem;
        PotionMeta potionMeta;
        Brew brew;
        ItemMeta itemMeta;
        boolean upperInventoryIsClicked;
        boolean isVanillaBarrel;
        InventoryHolder holder = PaperLib.getHolder(event.getInventory(), true).getHolder();
        boolean bl = isVanillaBarrel = VERSION.isOrLater(MinecraftVersion.V1_14) && holder instanceof org.bukkit.block.Barrel;
        if (isVanillaBarrel && this.config.isExemptVanillaBarrels()) {
            return;
        }
        if (!(holder instanceof Barrel) && !isVanillaBarrel) {
            return;
        }
        InventoryAction action = event.getAction();
        if (action == InventoryAction.NOTHING) {
            return;
        }
        boolean bl2 = upperInventoryIsClicked = event.getClickedInventory() == event.getInventory();
        if (!upperInventoryIsClicked && CLICKED_INVENTORY_ITEM_MOVE.contains(action)) {
            return;
        }
        ItemStack hoveredItem = event.getCurrentItem();
        if (upperInventoryIsClicked && hoveredItem != null && (itemMeta = hoveredItem.getItemMeta()) instanceof PotionMeta && (brew = Brew.get((ItemMeta)(potionMeta = (PotionMeta)itemMeta))) != null) {
            BrewLore lore = new BrewLore(brew, potionMeta);
            if (BrewLore.hasColorLore(potionMeta)) {
                lore.convertLore(false);
                lore.write();
            } else if (!this.config.isAlwaysShowAlc() && event.getInventory().getType() == InventoryType.BREWING) {
                lore.updateAlc(false);
                lore.write();
            }
            hoveredItem.setItemMeta((ItemMeta)potionMeta);
        }
        if (!this.config.isOnlyAllowBrewsInBarrels()) {
            return;
        }
        if (BANNED_ACTIONS.contains(action.name())) {
            event.setResult(Event.Result.DENY);
            return;
        }
        InventoryView view = event.getView();
        ItemStack itemStack = event.getHotbarButton() == -1 ? (event.getClick() == ClickType.SWAP_OFFHAND ? event.getWhoClicked().getInventory().getItemInOffHand() : null) : (hotbarItem = view.getBottomInventory().getItem(event.getHotbarButton()));
        if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            if (upperInventoryIsClicked && hotbarItem == null) {
                return;
            }
            relatedItems = Stream.of(hotbarItem, hoveredItem);
        } else if (action == InventoryAction.HOTBAR_SWAP) {
            if (!upperInventoryIsClicked) {
                return;
            }
            relatedItems = Stream.of(hotbarItem, hoveredItem);
        } else {
            ItemStack cursor = event.getCursor();
            relatedItems = Stream.of(cursor);
        }
        Stream<ItemStack> itemsToCheck = relatedItems.filter(Objects::nonNull).filter(item -> !item.getType().isAir());
        if (itemsToCheck.anyMatch(item -> !this.isBrewItem((ItemStack)item))) {
            event.setResult(Event.Result.DENY);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        boolean isVanillaBarrel;
        InventoryView view = event.getView();
        Inventory topInventory = view.getTopInventory();
        InventoryHolder holder = PaperLib.getHolder(topInventory, true).getHolder();
        boolean bl = isVanillaBarrel = VERSION.isOrLater(MinecraftVersion.V1_14) && holder instanceof org.bukkit.block.Barrel;
        if (isVanillaBarrel && this.config.isExemptVanillaBarrels()) {
            return;
        }
        if (!(holder instanceof Barrel) && !isVanillaBarrel) {
            return;
        }
        int topSize = topInventory.getSize();
        for (Map.Entry entry : event.getNewItems().entrySet()) {
            ItemStack item;
            int rawSlot = (Integer)entry.getKey();
            if (rawSlot >= topSize || (item = (ItemStack)entry.getValue()) == null || item.getType().isAir() || this.isBrewItem(item)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClickMCBarrel(InventoryClickEvent event) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.BARREL) {
            return;
        }
        if (!this.config.isAgeInMCBarrels()) {
            return;
        }
        Inventory inv = event.getInventory();
        for (MCBarrel barrel : MCBarrel.openBarrels) {
            if (!barrel.getInventory().equals((Object)inv)) continue;
            barrel.clickInv(event);
            return;
        }
        MCBarrel barrel = new MCBarrel(inv);
        MCBarrel.openBarrels.add(barrel);
        barrel.clickInv(event);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClickBSealer(InventoryClickEvent event) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_13)) {
            return;
        }
        InventoryHolder holder = PaperLib.getHolder(event.getInventory(), true).getHolder();
        if (!(holder instanceof BSealer)) {
            return;
        }
        ((BSealer)holder).clickInv();
    }

    @EventHandler(ignoreCancelled=false)
    public void onInventoryOpenLegacyConvert(InventoryOpenEvent event) {
        if (Brew.noLegacy()) {
            return;
        }
        if (event.getInventory().getType() == InventoryType.PLAYER) {
            return;
        }
        for (ItemStack item : event.getInventory().getContents()) {
            int uid;
            if (item == null || item.getType() != Material.POTION || (uid = Brew.getUID(item)) >= 0 || !Brew.legacyPotions.containsKey(uid)) continue;
            Brew.get(item);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
            return;
        }
        if (!this.config.isAgeInMCBarrels()) {
            return;
        }
        if (event.getInventory().getType() == InventoryType.BARREL) {
            Inventory inv = event.getInventory();
            for (MCBarrel barrel : MCBarrel.openBarrels) {
                if (!barrel.getInventory().equals((Object)inv)) continue;
                barrel.open();
                return;
            }
            MCBarrel barrel = new MCBarrel(inv);
            MCBarrel.openBarrels.add(barrel);
            barrel.open();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHopperPickupPuke(InventoryPickupItemEvent event) {
        if (event.getItem().getPickupDelay() > 1000 && this.config.getPukeItem().contains(event.getItem().getItemStack().getType())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onHopperMove(InventoryMoveItemEvent event) {
        ItemStack item;
        BrewerInventory inv;
        Inventory inventory = event.getSource();
        if (inventory instanceof BrewerInventory && (inventory = PaperLib.getHolder((Inventory)(inv = (BrewerInventory)inventory), true).getHolder()) instanceof BrewingStand) {
            BrewingStand holder = (BrewingStand)inventory;
            if (BDistiller.isTrackingDistiller(holder.getBlock())) {
                event.setCancelled(true);
            }
            return;
        }
        if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
            return;
        }
        if (event.getSource().getType() == InventoryType.BARREL && (item = event.getItem()).getType() == Material.POTION && Brew.isBrew(item)) {
            Brew brew;
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            assert (meta != null);
            if (BrewLore.hasColorLore(meta) && (brew = Brew.get((ItemMeta)meta)) != null) {
                BrewLore lore = new BrewLore(brew, meta);
                lore.convertLore(false);
                lore.write();
                item.setItemMeta((ItemMeta)meta);
                event.setItem(item);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_13)) {
            return;
        }
        InventoryHolder inventoryHolder = PaperLib.getHolder(event.getInventory(), true).getHolder();
        if (inventoryHolder instanceof BSealer) {
            BSealer holder = (BSealer)inventoryHolder;
            holder.closeInv();
        }
        if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
            return;
        }
        inventoryHolder = PaperLib.getHolder(event.getInventory(), true).getHolder();
        if (inventoryHolder instanceof Barrel) {
            Barrel barrel = (Barrel)inventoryHolder;
            barrel.playClosingSound();
        }
        if (this.config.isAgeInMCBarrels() && event.getInventory().getType() == InventoryType.BARREL) {
            Inventory inv = event.getInventory();
            Iterator<MCBarrel> iter = MCBarrel.openBarrels.iterator();
            while (iter.hasNext()) {
                MCBarrel barrel = iter.next();
                if (!barrel.getInventory().equals((Object)inv)) continue;
                barrel.close();
                if (inv.getViewers().size() == 1) {
                    iter.remove();
                }
                return;
            }
            new MCBarrel(inv).close();
        }
    }
}

