/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.lore;

import com.dre.brewery.lore.basE91;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base91DecoderStream
extends FilterInputStream {
    private final basE91 decoder = new basE91();
    private byte[] decbuf = new byte[32];
    private byte[] buf = new byte[32];
    private int reader = 0;
    private int count = 0;
    private byte[] markBuf = null;

    public Base91DecoderStream(InputStream in) {
        super(in);
    }

    private void decode() throws IOException {
        this.reader = 0;
        this.count = this.in.read(this.decbuf);
        if (this.count < 1) {
            this.count = this.decoder.decEnd(this.buf);
            if (this.count < 1) {
                this.count = -1;
            }
            return;
        }
        this.count = this.decoder.decode(this.decbuf, this.count, this.buf);
    }

    @Override
    public int read() throws IOException {
        if (this.count == -1) {
            return -1;
        }
        if (this.count == 0 || this.reader == this.count) {
            this.decode();
            return this.read();
        }
        return this.buf[this.reader++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.count == -1) {
            return -1;
        }
        if (this.count == 0 || this.reader == this.count) {
            this.decode();
            if (this.count == -1) {
                return -1;
            }
        }
        if (this.count > 0 && this.count - this.reader >= len) {
            System.arraycopy(this.buf, this.reader, b, off, len);
            this.reader += len;
            return len;
        }
        int out = 0;
        while (this.count > 0) {
            int writeSize = Math.min(len, this.count - this.reader);
            System.arraycopy(this.buf, this.reader, b, off + out, writeSize);
            out += writeSize;
            if ((len -= writeSize) > 0) {
                this.decode();
                continue;
            }
            this.reader += writeSize;
            break;
        }
        return out;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.count == -1) {
            return 0L;
        }
        if (this.count > 0 && (long)(this.count - this.reader) >= n) {
            this.reader = (int)((long)this.reader + n);
            return n;
        }
        long skipped = this.count - this.reader;
        this.decode();
        while (this.count > 0) {
            if ((long)this.count > n - skipped) {
                this.reader = (int)(n - skipped);
                return n;
            }
            skipped += (long)this.count;
            this.decode();
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this.count == -1) {
            return 0;
        }
        return (int)((float)this.in.available() * 0.813f) + this.count - this.reader;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.count = -1;
        this.decoder.decReset();
        this.buf = null;
        this.decbuf = null;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (!this.markSupported()) {
            return;
        }
        if (this.count == -1) {
            return;
        }
        this.in.mark(readlimit);
        this.decoder.decMark();
        if (this.count > 0 && this.reader < this.count) {
            this.markBuf = new byte[this.count - this.reader];
            System.arraycopy(this.buf, this.reader, this.markBuf, 0, this.markBuf.length);
        } else {
            this.markBuf = null;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("mark and reset not supported by underlying Stream");
        }
        this.in.reset();
        this.decoder.decUnmark();
        this.reader = 0;
        this.count = 0;
        if (this.markBuf != null) {
            System.arraycopy(this.markBuf, 0, this.buf, 0, this.markBuf.length);
            this.count = this.markBuf.length;
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

