/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.lore;

import com.dre.brewery.lore.SeedInputStream;
import com.dre.brewery.utility.Logging;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XORUnscrambleStream
extends FilterInputStream {
    private long seed;
    private final List<Long> prevSeeds;
    private SeedInputStream xorStream;
    private boolean running;
    private boolean markRunning;
    private boolean markxor;
    private SuccessType successType = SuccessType.NONE;

    public XORUnscrambleStream(InputStream in, long seed) {
        super(in);
        this.seed = seed;
        this.prevSeeds = null;
    }

    public XORUnscrambleStream(InputStream in, long seed, List<Long> prevSeeds) {
        super(in);
        this.seed = seed;
        this.prevSeeds = prevSeeds;
    }

    public void start() throws IOException, InvalidKeyException {
        this.running = true;
        if (this.xorStream == null) {
            short id = (short)(this.in.read() << 8 | this.in.read());
            if (id == 0) {
                this.running = false;
                this.successType = SuccessType.UNSCRAMBLED;
                Logging.debugLog("Unscrambled data");
                return;
            }
            int parity = this.in.read();
            this.xorStream = new SeedInputStream(this.seed ^ (long)id);
            boolean success = this.checkParity(parity);
            if (success) {
                this.successType = SuccessType.MAIN_SEED;
                Logging.debugLog("Using main Seed to unscramble");
            }
            if (!success && this.prevSeeds != null) {
                for (int i = this.prevSeeds.size() - 1; i >= 0; --i) {
                    this.seed = this.prevSeeds.get(i);
                    this.xorStream = new SeedInputStream(this.seed ^ (long)id);
                    success = this.checkParity(parity);
                    if (!success) continue;
                    this.successType = SuccessType.PREV_SEED;
                    Logging.debugLog("Had to use prevSeed to unscramble");
                    break;
                }
            }
            if (!success) {
                throw new InvalidKeyException("Could not read scrambled data, is the seed wrong?");
            }
        }
    }

    private boolean checkParity(int parity) {
        return ((parity ^ this.xorStream.read()) & 0xFF) == ((int)(this.seed >> 48) & 0xFF);
    }

    public void stop() {
        this.running = false;
    }

    @Override
    public int read() throws IOException {
        if (!this.running) {
            return this.in.read();
        }
        return (this.in.read() ^ this.xorStream.read()) & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (!this.running) {
            return this.in.read(b, off, len);
        }
        len = this.in.read(b, off, len);
        int i = off;
        while (i < len + off) {
            int n = i++;
            b[n] = (byte)(b[n] ^ this.xorStream.read());
        }
        return len;
    }

    public SuccessType getSuccessType() {
        return this.successType;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        if (this.running && skipped > 0L) {
            this.xorStream.skip(skipped);
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        if (this.xorStream != null) {
            this.xorStream.close();
            this.xorStream = null;
        }
        this.running = false;
        super.close();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        if (this.markxor) {
            this.xorStream.reset();
        } else {
            this.xorStream = null;
        }
        this.running = this.markRunning;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        if (this.xorStream != null) {
            this.xorStream.mark(readlimit);
            this.markxor = true;
        }
        this.markRunning = this.running;
    }

    public static enum SuccessType {
        UNSCRAMBLED,
        MAIN_SEED,
        PREV_SEED,
        NONE;

    }
}

