/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.BukkitConstants;
import com.dre.brewery.utility.MinecraftVersion;
import org.bukkit.Color;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class PotionColor {
    private static final String HEX_STRING = "#%02x%02x%02x";
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    public static final PotionColor PINK = new PotionColor(1, BukkitConstants.POTION_REGENERATION, Color.FUCHSIA);
    public static final PotionColor CYAN = new PotionColor(2, BukkitConstants.POTION_SWIFTNESS, Color.AQUA);
    public static final PotionColor ORANGE = new PotionColor(3, BukkitConstants.POTION_FIRE_RESISTANCE, Color.ORANGE);
    public static final PotionColor GREEN = new PotionColor(4, BukkitConstants.POTION_POISON, Color.GREEN);
    public static final PotionColor BRIGHT_RED = new PotionColor(5, BukkitConstants.POTION_HEALING, Color.fromRGB((int)255, (int)0, (int)0));
    public static final PotionColor BLUE = new PotionColor(6, BukkitConstants.POTION_NIGHT_VISION, Color.NAVY);
    public static final PotionColor BLACK = new PotionColor(8, BukkitConstants.POTION_WEAKNESS, Color.BLACK);
    public static final PotionColor RED = new PotionColor(9, BukkitConstants.POTION_STRENGTH, Color.fromRGB((int)196, (int)0, (int)0));
    public static final PotionColor GREY = new PotionColor(10, BukkitConstants.POTION_SLOWNESS, Color.GRAY);
    public static final PotionColor WATER = new PotionColor(11, (PotionType)(VERSION.isOrLater(MinecraftVersion.V1_9) ? BukkitConstants.POTION_WATER_BREATHING : null), Color.BLUE);
    public static final PotionColor DARK_RED = new PotionColor(12, BukkitConstants.POTION_HARMING, Color.fromRGB((int)128, (int)0, (int)0));
    public static final PotionColor BRIGHT_GREY = new PotionColor(14, BukkitConstants.POTION_INVISIBILITY, Color.SILVER);
    public static final PotionColor WHITE = new PotionColor(Color.WHITE);
    public static final PotionColor LIME = new PotionColor(Color.LIME);
    public static final PotionColor OLIVE = new PotionColor(Color.OLIVE);
    public static final PotionColor PURPLE = new PotionColor(Color.PURPLE);
    public static final PotionColor TEAL = new PotionColor(Color.TEAL);
    public static final PotionColor YELLOW = new PotionColor(Color.YELLOW);
    private final int colorId;
    private final PotionType type;
    private final Color color;

    PotionColor(int colorId, PotionType type, Color color) {
        this.colorId = colorId;
        this.type = type;
        this.color = color;
    }

    public PotionColor(Color color) {
        this.colorId = PotionColor.WATER.colorId;
        this.type = WATER.getType();
        this.color = color;
    }

    public short getColorId(boolean destillable) {
        if (destillable) {
            return (short)(this.colorId + 64);
        }
        return (short)(this.colorId + 32);
    }

    public void colorBrew(PotionMeta meta, ItemStack potion, boolean destillable) {
        if (VERSION.isOrLater(MinecraftVersion.V1_9)) {
            meta.addItemFlags(ItemFlag.values());
            if (VERSION.isOrLater(MinecraftVersion.V1_11)) {
                meta.setColor(this.getColor());
            } else {
                meta.setBasePotionType(this.getType());
            }
        } else {
            potion.setDurability(this.getColorId(destillable));
            meta.addCustomEffect(BukkitConstants.REGENERATION.createEffect(0, 0), true);
        }
    }

    public static PotionColor fromString(String string) {
        return switch (string.toUpperCase()) {
            case "PINK" -> {
                PotionColor var3_3;
                yield var3_3 = PINK;
            }
            case "CYAN" -> {
                PotionColor var3_4;
                yield var3_4 = CYAN;
            }
            case "ORANGE" -> {
                PotionColor var3_5;
                yield var3_5 = ORANGE;
            }
            case "GREEN" -> {
                PotionColor var3_6;
                yield var3_6 = GREEN;
            }
            case "BRIGHT_RED" -> {
                PotionColor var3_7;
                yield var3_7 = BRIGHT_RED;
            }
            case "BLUE" -> {
                PotionColor var3_8;
                yield var3_8 = BLUE;
            }
            case "BLACK" -> {
                PotionColor var3_9;
                yield var3_9 = BLACK;
            }
            case "RED" -> {
                PotionColor var3_10;
                yield var3_10 = RED;
            }
            case "GREY" -> {
                PotionColor var3_11;
                yield var3_11 = GREY;
            }
            case "WATER" -> {
                PotionColor var3_12;
                yield var3_12 = WATER;
            }
            case "DARK_RED" -> {
                PotionColor var3_13;
                yield var3_13 = DARK_RED;
            }
            case "BRIGHT_GREY" -> {
                PotionColor var3_14;
                yield var3_14 = BRIGHT_GREY;
            }
            case "WHITE" -> {
                PotionColor var3_15;
                yield var3_15 = WHITE;
            }
            case "LIME" -> {
                PotionColor var3_16;
                yield var3_16 = LIME;
            }
            case "OLIVE" -> {
                PotionColor var3_17;
                yield var3_17 = OLIVE;
            }
            case "PURPLE" -> {
                PotionColor var3_18;
                yield var3_18 = PURPLE;
            }
            case "TEAL" -> {
                PotionColor var3_19;
                yield var3_19 = TEAL;
            }
            case "YELLOW" -> {
                PotionColor var3_20;
                yield var3_20 = YELLOW;
            }
            default -> {
                try {
                    PotionColor var3_21;
                    if (string.length() >= 7) {
                        string = string.substring(1);
                    }
                    yield var3_21 = new PotionColor(Color.fromRGB((int)Integer.parseInt(string.substring(0, 2), 16), (int)Integer.parseInt(string.substring(2, 4), 16), (int)Integer.parseInt(string.substring(4, 6), 16)));
                }
                catch (NumberFormatException e) {
                    PotionColor var3_22;
                    yield var3_22 = WATER;
                }
            }
        };
    }

    public static PotionColor fromColor(Color color) {
        return new PotionColor(color);
    }

    public String toString() {
        return String.format(HEX_STRING, this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public int getColorId() {
        return this.colorId;
    }

    public PotionType getType() {
        return this.type;
    }

    public Color getColor() {
        return this.color;
    }
}

