/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BrewDefect;
import com.dre.brewery.recipe.QualityDeduction;
import com.dre.brewery.utility.BUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class RecipeEvaluation {
    private final List<QualityDeduction> deductions = new ArrayList<QualityDeduction>();

    public void deduct(BrewDefect defect, float qualityDeduction) {
        if (qualityDeduction < 0.0f) {
            throw new IllegalArgumentException("qualityDeduction cannot be negative");
        }
        this.deductions.add(QualityDeduction.deduction(defect, qualityDeduction));
    }

    public void fatal(BrewDefect defect) {
        this.deductions.add(QualityDeduction.fatal(defect));
    }

    public static RecipeEvaluation combine(RecipeEvaluation ... evals) {
        RecipeEvaluation combined = new RecipeEvaluation();
        for (RecipeEvaluation eval : evals) {
            List<QualityDeduction> scaledDown = eval.deductions.stream().map(d -> d.scale(1.0f / (float)evals.length)).toList();
            combined.deductions.addAll(scaledDown);
        }
        return combined;
    }

    public boolean isFatal() {
        return this.getTrueQuality() < 0.0f;
    }

    private boolean hasFatalDefect() {
        return this.deductions.stream().anyMatch(QualityDeduction::isFatal);
    }

    public int getQuality() {
        float quality = this.getTrueQuality();
        if (quality < 0.0f) {
            return -1;
        }
        return Math.round(quality);
    }

    public float getTrueQuality() {
        if (this.hasFatalDefect()) {
            return Float.NEGATIVE_INFINITY;
        }
        return this.deductions.stream().map(QualityDeduction::getQualityDeduction).reduce(Float.valueOf(10.0f), (q1, q2) -> Float.valueOf(q1.floatValue() - q2.floatValue())).floatValue();
    }

    public List<QualityDeduction> getDeductions() {
        return Collections.unmodifiableList(this.deductions);
    }

    public List<BrewDefect> getWorstDefects() {
        if (this.hasFatalDefect()) {
            return this.deductions.stream().filter(QualityDeduction::isFatal).map(QualityDeduction::getDefect).toList();
        }
        return BUtil.multiMin(this.deductions).stream().map(QualityDeduction::getDefect).toList();
    }

    public int compareMostToLeastComplexity(RecipeEvaluation other) {
        boolean otherFatal;
        if (other == null) {
            throw new NullPointerException("other cannot be null");
        }
        int numDefectsCompare = -Integer.compare(this.deductions.size(), other.deductions.size());
        if (numDefectsCompare != 0) {
            return numDefectsCompare;
        }
        int thisFatalCount = this.fatalCount();
        boolean thisFatal = thisFatalCount > 0;
        int otherFatalCount = other.fatalCount();
        boolean bl = otherFatal = otherFatalCount > 0;
        if (!thisFatal && !otherFatal) {
            return Float.compare(this.getTrueQuality(), other.getTrueQuality());
        }
        if (thisFatal && otherFatal) {
            return -Integer.compare(thisFatalCount, otherFatalCount);
        }
        return -Boolean.compare(thisFatal, otherFatal);
    }

    private int fatalCount() {
        return (int)this.deductions.stream().filter(QualityDeduction::isFatal).count();
    }

    public String toString() {
        float quality = this.getTrueQuality();
        String qualityStr = quality == Float.NEGATIVE_INFINITY ? "fatal" : String.format("%.3f", Float.valueOf(quality));
        String deductionsStr = this.deductions.stream().map(QualityDeduction::toString).collect(Collectors.joining(", ", "[", "]"));
        return new StringJoiner(", ", "{", "}").add("quality=" + qualityStr).add("deductions=" + deductionsStr).toString();
    }
}

