/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.ItemLoader;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SimpleItem
extends RecipeItem
implements Ingredient {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private Material mat;
    private short dur;

    public SimpleItem(Material mat) {
        this(mat, 0);
    }

    public SimpleItem(Material mat, short dur) {
        this.mat = mat;
        this.dur = dur;
    }

    @Override
    public boolean hasMaterials() {
        return this.mat != null;
    }

    public Material getMaterial() {
        return this.mat;
    }

    @Override
    public List<Material> getMaterials() {
        ArrayList<Material> l = new ArrayList<Material>(1);
        l.add(this.mat);
        return l;
    }

    @Override
    @NotNull
    public Ingredient toIngredient(ItemStack forItem) {
        return (SimpleItem)this.getMutableCopy();
    }

    @Override
    @NotNull
    public Ingredient toIngredientGeneric() {
        return (SimpleItem)this.getMutableCopy();
    }

    @Override
    public boolean matches(ItemStack item) {
        if (!this.mat.equals((Object)item.getType())) {
            return false;
        }
        return VERSION.isOrLater(MinecraftVersion.V1_13) || this.dur == item.getDurability();
    }

    @Override
    public boolean matches(Ingredient ingredient) {
        if (this.isSimilar(ingredient)) {
            return true;
        }
        if (ingredient instanceof RecipeItem) {
            if (!((RecipeItem)((Object)ingredient)).hasMaterials()) {
                return false;
            }
            if (ingredient instanceof CustomItem) {
                CustomItem ci = (CustomItem)ingredient;
                return !ci.hasLore() && !ci.hasName() && this.mat == ci.getMaterial();
            }
        }
        return false;
    }

    @Override
    public boolean isSimilar(Ingredient item) {
        if (this == item) {
            return true;
        }
        if (item instanceof SimpleItem) {
            SimpleItem si = (SimpleItem)item;
            return si.mat == this.mat && si.dur == this.dur;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleItem item = (SimpleItem)o;
        return this.dur == item.dur && this.mat == item.mat;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mat, this.dur);
    }

    @Override
    public String toString() {
        return "SimpleItem{mat=" + this.getDebugID() + " amount=" + this.getAmount() + "}";
    }

    @Override
    public String getDebugID() {
        return this.mat.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public void saveTo(DataOutputStream out) throws IOException {
        out.writeUTF("SI");
        out.writeUTF(this.mat.name());
        out.writeShort(this.dur);
    }

    public static SimpleItem loadFrom(ItemLoader loader) {
        try {
            DataInputStream in = loader.getInputStream();
            Material mat = Material.getMaterial((String)in.readUTF());
            short dur = in.readShort();
            if (mat != null) {
                SimpleItem item = new SimpleItem(mat, dur);
                return item;
            }
        }
        catch (IOException e) {
            Logging.errorLog("Failed to load SimpleItem", e);
        }
        return null;
    }

    public static void registerItemLoader(BreweryPlugin breweryPlugin) {
        breweryPlugin.registerForItemLoader("SI", SimpleItem::loadFrom);
    }
}

