/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage.records;

import com.dre.brewery.Barrel;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.interfaces.SerializableThing;
import com.dre.brewery.storage.serialization.BukkitSerialization;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BoundingBox;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;

public record SerializableBarrel(String id, String serializedLocation, List<Integer> bounds, float time, byte sign, String serializedItems) implements SerializableThing
{
    public SerializableBarrel(Barrel barrel) {
        this(barrel.getId().toString(), DataManager.serializeLocation(barrel.getSpigot().getLocation()), barrel.getBounds().serializeToIntList(), barrel.getTime(), barrel.getSignoffset(), BukkitSerialization.itemStackArrayToBase64(barrel.getInventory().getContents()));
    }

    public CompletableFuture<Barrel> toBarrel() {
        Location loc = DataManager.deserializeLocation(this.serializedLocation);
        if (loc == null) {
            return CompletableFuture.completedFuture(null);
        }
        return Barrel.computeSmall(loc).thenApplyAsync(small -> new Barrel(loc.getBlock(), this.sign, BoundingBox.fromPoints(this.bounds), BukkitSerialization.itemStackArrayFromBase64(this.serializedItems), this.time, BUtil.uuidFromString(this.id), (boolean)small));
    }

    @Override
    public String getId() {
        return this.id;
    }
}

