/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class BoundingBox {
    private BlockPos min;
    private BlockPos max;

    public BoundingBox(BlockPos a, BlockPos b) {
        this(a.x, a.y, a.z, b.x, b.y, b.z);
    }

    public BoundingBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        this.min = new BlockPos(minX, minY, minZ);
        int maxX = Math.max(x2, x1);
        int maxY = Math.max(y2, y1);
        int maxZ = Math.max(z2, z1);
        this.max = new BlockPos(maxX, maxY, maxZ);
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.min.x && x <= this.max.x && y >= this.min.y && y <= this.max.y && z >= this.min.z && z <= this.max.z;
    }

    public boolean contains(Location loc) {
        return this.contains(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public boolean contains(Block block) {
        return this.contains(block.getX(), block.getY(), block.getZ());
    }

    public boolean intersects(BoundingBox other) {
        if (other == null) {
            return false;
        }
        return this.max.x >= other.min.x && this.min.x <= other.max.x && this.max.y >= other.min.y && this.min.y <= other.max.y && this.max.z >= other.min.z && this.min.z <= other.max.z;
    }

    public long volume() {
        return (long)(this.max.z - this.min.z + 1) * (long)(this.max.y - this.min.y + 1) * (long)(this.max.z - this.min.z + 1);
    }

    public boolean isBad() {
        long volume = this.volume();
        return volume != 8L && volume != 36L;
    }

    public void resize(int x1, int y1, int z1, int x2, int y2, int z2) {
        BoundingBox box = new BoundingBox(x1, y1, z1, x2, y2, z2);
        this.min = box.min;
        this.max = box.max;
    }

    public String serialize() {
        return this.min.x + "," + this.min.y + "," + this.min.z + "," + this.max.x + "," + this.max.y + "," + this.max.z;
    }

    public List<Integer> serializeToIntList() {
        return List.of(Integer.valueOf(this.min.x), Integer.valueOf(this.min.y), Integer.valueOf(this.min.z), Integer.valueOf(this.max.x), Integer.valueOf(this.max.y), Integer.valueOf(this.max.z));
    }

    public static BoundingBox fromPoints(int[] locations) {
        if (locations.length % 3 != 0) {
            throw new IllegalArgumentException("Locations has to be pairs of three");
        }
        int length = locations.length - 2;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int minz = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        int maxz = Integer.MIN_VALUE;
        for (int i = 0; i < length; i += 3) {
            minx = Math.min(locations[i], minx);
            miny = Math.min(locations[i + 1], miny);
            minz = Math.min(locations[i + 2], minz);
            maxx = Math.max(locations[i], maxx);
            maxy = Math.max(locations[i + 1], maxy);
            maxz = Math.max(locations[i + 2], maxz);
        }
        return new BoundingBox(minx, miny, minz, maxx, maxy, maxz);
    }

    public static BoundingBox fromPoints(List<Integer> locations) {
        if (locations.size() % 3 != 0) {
            throw new IllegalArgumentException("Locations has to be pairs of three");
        }
        int length = locations.size() - 2;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int minz = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        int maxz = Integer.MIN_VALUE;
        for (int i = 0; i < length; i += 3) {
            minx = Math.min(locations.get(i), minx);
            miny = Math.min(locations.get(i + 1), miny);
            minz = Math.min(locations.get(i + 2), minz);
            maxx = Math.max(locations.get(i), maxx);
            maxy = Math.max(locations.get(i + 1), maxy);
            maxz = Math.max(locations.get(i + 2), maxz);
        }
        return new BoundingBox(minx, miny, minz, maxx, maxy, maxz);
    }

    public BlockPos getMin() {
        return this.min;
    }

    public BlockPos getMax() {
        return this.max;
    }

    public void setMin(BlockPos min) {
        this.min = min;
    }

    public void setMax(BlockPos max) {
        this.max = max;
    }

    public record BlockPos(int x, int y, int z) {
    }
}

