/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class OptionalFloat {
    private static final OptionalFloat EMPTY = new OptionalFloat();
    private final float value;
    private final boolean isPresent;

    private OptionalFloat(float value) {
        this.value = value;
        this.isPresent = true;
    }

    private OptionalFloat() {
        this.value = 0.0f;
        this.isPresent = false;
    }

    public static OptionalFloat of(float value) {
        return new OptionalFloat(value);
    }

    public static OptionalFloat empty() {
        return EMPTY;
    }

    public float getAsFloat() {
        if (!this.isPresent) {
            throw new IllegalStateException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(Consumer<Float> action) {
        if (this.isPresent) {
            action.accept(Float.valueOf(this.value));
        }
    }

    public void ifPresentOrElse(Consumer<Float> action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(Float.valueOf(this.value));
        } else {
            emptyAction.run();
        }
    }

    public float orElse(float other) {
        return this.isPresent ? this.value : other;
    }

    public float orElseGet(Supplier<Float> other) {
        return this.isPresent ? this.value : other.get().floatValue();
    }

    public <X extends Throwable> float orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public String toString() {
        return this.isPresent ? "OptionalFloat[" + this.value + "]" : "OptionalFloat.empty";
    }
}

