/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class PermissionUtil {
    public static Map<CommandSender, Boolean> extendedPermsCache = new HashMap<CommandSender, Boolean>();

    public static void logout(CommandSender sender) {
        extendedPermsCache.remove(sender);
    }

    public static void evaluateExtendedPermissions(CommandSender sender) {
        for (BPermission perm : BPermission.values()) {
            if (perm == BPermission.UNLABEL || !sender.hasPermission(perm.permission)) continue;
            extendedPermsCache.put(sender, true);
            return;
        }
        extendedPermsCache.put(sender, false);
    }

    public static boolean noExtendedPermissions(CommandSender sender) {
        Boolean extendedPerms = extendedPermsCache.get(sender);
        if (extendedPerms == null) {
            PermissionUtil.evaluateExtendedPermissions(sender);
            extendedPerms = extendedPermsCache.get(sender);
        }
        return extendedPerms == null || extendedPerms == false;
    }

    public static boolean hasCachedPermission(CommandSender sender, String permission) {
        BPermission perm = BPermission.get(permission);
        if (perm != null) {
            return PermissionUtil.hasCachedPermission(sender, perm);
        }
        return sender.hasPermission(permission);
    }

    public static boolean hasCachedPermission(CommandSender sender, BPermission bPerm) {
        if (bPerm != BPermission.UNLABEL && PermissionUtil.noExtendedPermissions(sender)) {
            return false;
        }
        return sender.hasPermission(bPerm.permission);
    }

    public static int getDrinkSensitive(Permissible player) {
        return PermissionUtil.getRangedPermission(player, "brewery.sensitive.");
    }

    public static int getAlcRecovery(Permissible player) {
        return PermissionUtil.getRangedPermission(player, "brewery.recovery.");
    }

    public static int getRangedPermission(Permissible player, String subPermission) {
        Optional<PermissionAttachmentInfo> found = player.getEffectivePermissions().stream().filter(PermissionAttachmentInfo::getValue).filter(x -> x.getPermission().startsWith(subPermission)).findFirst();
        if (found.isPresent()) {
            String permission = found.get().getPermission();
            int lastDot = permission.lastIndexOf(46);
            try {
                int value = Integer.parseInt(permission.substring(lastDot + 1));
                if (value >= 0) {
                    return value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static enum BPermission {
        SEAL("brewery.cmd.seal"),
        UNLABEL("brewery.cmd.unlabel"),
        INFO("brewery.cmd.info"),
        INFO_OTHER("brewery.cmd.infoOther"),
        CREATE("brewery.cmd.create"),
        DRINK("brewery.cmd.drink"),
        DRINK_OTHER("brewery.cmd.drinkOther"),
        RELOAD("brewery.cmd.reload"),
        PUKE("brewery.cmd.puke"),
        PUKE_OTHER("brewery.cmd.pukeOther"),
        WAKEUP("brewery.cmd.wakeup"),
        STATIC("brewery.cmd.static"),
        SET("brewery.cmd.set"),
        COPY("brewery.cmd.copy"),
        DELETE("brewery.cmd.delete");

        public String permission;

        private BPermission(String permission) {
            this.permission = permission;
        }

        public boolean checkCached(CommandSender sender) {
            return PermissionUtil.hasCachedPermission(sender, this);
        }

        public static BPermission get(String permission) {
            for (BPermission bPerm : BPermission.values()) {
                if (!bPerm.permission.equals(permission)) continue;
                return bPerm;
            }
            return null;
        }
    }
}

