/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.depend.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.dre.brewery.utility.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BSealer
implements InventoryHolder {
    public static final NamespacedKey TAG_KEY = new NamespacedKey((Plugin)BreweryPlugin.getInstance(), "SealingTable");
    public static final NamespacedKey LEGACY_TAG_KEY = new NamespacedKey("brewery", "sealingtable");
    public static boolean inventoryHolderWorking = true;
    private static final Config config = ConfigManager.getConfig(Config.class);
    private static final Lang lang = ConfigManager.getConfig(Lang.class);
    private final Inventory inventory;
    private final Player player;
    private final short[] slotTime = new short[9];
    private ItemStack[] contents = null;
    private MyScheduledTask task;

    public BSealer(Player player) {
        this.player = player;
        if (inventoryHolderWorking) {
            Inventory inv = Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.DISPENSER, (String)lang.getEntry("Etc_SealingTable", new Object[0]));
            if (PaperLib.getHolder(inv, true).getHolder() == this) {
                this.inventory = inv;
                return;
            }
            inventoryHolderWorking = false;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)9, (String)lang.getEntry("Etc_SealingTable", new Object[0]));
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void clickInv() {
        this.contents = null;
        if (this.task == null) {
            this.task = BreweryPlugin.getScheduler().runTaskTimer((Plugin)BreweryPlugin.getInstance(), this::itemChecking, 1L, 1L);
        }
    }

    public void closeInv() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        for (ItemStack item : this.contents = this.inventory.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            this.player.getWorld().dropItemNaturally(this.player.getLocation(), item);
        }
        this.contents = null;
        this.inventory.clear();
    }

    private void itemChecking() {
        if (this.contents == null) {
            this.contents = this.inventory.getContents();
            for (int i = 0; i < this.slotTime.length; ++i) {
                if (this.contents[i] == null || this.contents[i].getType() != Material.POTION) {
                    this.slotTime[i] = -1;
                    continue;
                }
                if (this.slotTime[i] >= 0) continue;
                this.slotTime[i] = 0;
            }
        }
        boolean playerValid = this.player.isValid() && !this.player.isDead();
        for (int i = 0; i < this.slotTime.length; ++i) {
            if (this.slotTime[i] > 20) {
                this.slotTime[i] = -1;
                Brew brew = Brew.get(this.contents[i]);
                if (brew == null || brew.isStripped()) continue;
                brew.seal(this.contents[i], this.player);
                if (!playerValid || !BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_9)) continue;
                this.player.playSound(this.player.getLocation(), Sound.ITEM_BOTTLE_FILL_DRAGONBREATH, 1.0f, 1.5f + (float)(Math.random() * 0.2));
                continue;
            }
            if (this.slotTime[i] < 0) continue;
            int n = i;
            this.slotTime[n] = (short)(this.slotTime[n] + 1);
        }
    }

    public static boolean isBSealer(Block block) {
        Container container;
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_14) && block.getType() == config.getSealingTableBlock() && (container = (Container)PaperLib.getBlockState(block, true).getState()).getCustomName() != null) {
            if (container.getCustomName().equals("\u00a7e" + lang.getEntry("Etc_SealingTable", new Object[0]))) {
                return true;
            }
            return container.getPersistentDataContainer().has(TAG_KEY, PersistentDataType.BYTE) || container.getPersistentDataContainer().has(LEGACY_TAG_KEY, PersistentDataType.BYTE);
        }
        return false;
    }

    public static void blockPlace(ItemStack item, Block block) {
        if (item.getType() == config.getSealingTableBlock() && item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            assert (itemMeta != null);
            if (itemMeta.hasDisplayName() && itemMeta.getDisplayName().equals("\u00a7e" + lang.getEntry("Etc_SealingTable", new Object[0])) || itemMeta.getPersistentDataContainer().has(TAG_KEY, PersistentDataType.BYTE)) {
                Container container = (Container)PaperLib.getBlockState(block, true).getState();
                BlockData blockData = container.getBlockData();
                if (blockData instanceof Directional) {
                    Directional dir = (Directional)blockData;
                    dir.setFacing(dir.getFacing().getOppositeFace());
                    container.setBlockData((BlockData)dir);
                }
                container.getPersistentDataContainer().set(TAG_KEY, PersistentDataType.BYTE, (Object)1);
                container.update();
            }
        }
    }

    public static void registerRecipe() {
        if (!config.isCraftSealingTable() && BSealer.recipeExists()) {
            BSealer.unregisterRecipe();
            return;
        }
        if (!config.isCraftSealingTable() || BSealer.recipeExists() || BreweryPlugin.getMCVersion().isOrEarlier(MinecraftVersion.V1_13)) {
            return;
        }
        ItemStack sealingTableItem = new ItemStack(config.getSealingTableBlock());
        ItemMeta meta = BreweryPlugin.getInstance().getServer().getItemFactory().getItemMeta(config.getSealingTableBlock());
        if (meta == null) {
            return;
        }
        meta.setDisplayName("\u00a7e" + lang.getEntry("Etc_SealingTable", new Object[0]));
        meta.getPersistentDataContainer().set(TAG_KEY, PersistentDataType.BYTE, (Object)1);
        sealingTableItem.setItemMeta(meta);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)BreweryPlugin.getInstance(), "SealingTable"), sealingTableItem);
        recipe.shape(new String[]{"bb ", "ww ", "ww "});
        recipe.setIngredient('b', Material.GLASS_BOTTLE);
        recipe.setIngredient('w', (RecipeChoice)new RecipeChoice.MaterialChoice(Tag.PLANKS));
        Bukkit.getServer().addRecipe((Recipe)recipe);
    }

    public static boolean recipeExists() {
        Recipe recipe = Bukkit.getRecipe((NamespacedKey)TAG_KEY);
        return recipe != null;
    }

    public static void unregisterRecipe() {
        Recipe recipe = Bukkit.getRecipe((NamespacedKey)TAG_KEY);
        if (recipe != null) {
            Bukkit.removeRecipe((NamespacedKey)TAG_KEY);
        }
    }
}

